/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.mimelookup.impl.CompoundFolderChildren;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.spi.CustomInstanceFactory;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class FolderPathLookup
extends AbstractLookup {
    private static final String ATTR_ORIGINAL_FILE = "originalFile";
    private static final String EXTENSION_SHADOW = "shadow";
    private static final String ATTR_INSTANCE_OF = "instanceOf";
    private static final Logger LOG = Logger.getLogger(FolderPathLookup.class.getName());
    private final InstanceContent content;
    private final CompoundFolderChildren children;
    private final PCL listener = new PCL();
    private static final Map<FileObject, InstanceItem> fo2item = new HashMap<FileObject, InstanceItem>(128);
    private static volatile Lookup.Result<CustomInstanceFactory> factories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InstanceItem getInstanceItem(FileObject fo, InstanceItem ignoreItem) {
        Object originalFile;
        FileObject real = fo;
        if (EXTENSION_SHADOW.equals(fo.getExt()) && (originalFile = fo.getAttribute(ATTR_ORIGINAL_FILE)) instanceof String) {
            try {
                FileObject r = fo.getFileSystem().getRoot().getFileObject(originalFile.toString());
                if (r != null) {
                    real = r;
                } else {
                    LOG.warning("Dangling shadow found: " + fo.getPath() + " -> " + originalFile);
                }
            }
            catch (FileStateInvalidException ex) {
                LOG.log(Level.WARNING, "Unexpected error accessing config file " + fo, ex);
            }
        }
        Map<FileObject, InstanceItem> map = fo2item;
        synchronized (map) {
            InstanceItem item = fo2item.get(fo);
            if (item == null || item == ignoreItem) {
                item = new InstanceItem(real);
                fo2item.put(fo, item);
            }
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseInstanceItem(InstanceItem item) {
        Map<FileObject, InstanceItem> map = fo2item;
        synchronized (map) {
            InstanceItem removed = fo2item.remove(item.getFileObject());
            if (removed != item) {
                fo2item.put(item.getFileObject(), removed);
            }
        }
    }

    public FolderPathLookup(String[] paths) {
        this(paths, new InstanceContent());
    }

    private FolderPathLookup(String[] paths, InstanceContent content) {
        super((AbstractLookup.Content)content);
        this.content = content;
        this.children = new CompoundFolderChildren(paths, false);
        this.children.addPropertyChangeListener(this.listener);
        this.rebuild();
    }

    private void rebuild() {
        ArrayList<PairItem> pairItems = new ArrayList<PairItem>();
        for (FileObject fo : this.children.getChildren()) {
            if (!fo.isValid()) continue;
            pairItems.add(new PairItem(fo));
        }
        this.content.setPairs(pairItems);
    }

    private static Collection<? extends CustomInstanceFactory> getInstanceFactories() {
        Lookup.Result<CustomInstanceFactory> v = factories;
        if (v != null) {
            return v.allInstances();
        }
        final Lookup.Result[] fr = new Lookup.Result[1];
        Lookups.executeWith(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                fr[0] = factories = Lookup.getDefault().lookupResult(CustomInstanceFactory.class);
            }
        });
        return fr[0].allInstances();
    }

    public static final <T> T createInstance(Class<T> type) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        CustomInstanceFactory fif;
        Object r = null;
        Iterator<? extends CustomInstanceFactory> i$ = FolderPathLookup.getInstanceFactories().iterator();
        while (i$.hasNext() && (r = (fif = i$.next()).createInstance(type)) == null) {
        }
        if (r == null) {
            Constructor<T> init = type.getDeclaredConstructor(new Class[0]);
            init.setAccessible(true);
            r = init.newInstance(new Object[0]);
        }
        return (T)r;
    }

    private static final class InstanceItem {
        static final long serialVersionUID = 10L;
        private final FileObject fo;
        private transient Reference<Object> ref;

        InstanceItem(FileObject fo) {
            assert (fo != null) : "FileObject must not be null";
            this.fo = fo;
        }

        FileObject getFileObject() {
            return this.fo;
        }

        private synchronized Reference<Object> getRef() {
            return this.ref;
        }

        private synchronized void setRef(Reference<Object> ref) {
            this.ref = ref;
        }

        protected boolean instanceOf(Class<?> c) {
            Object inst;
            Reference<Object> refL = this.getRef();
            Object object = inst = refL != null ? refL.get() : null;
            if (inst != null) {
                return c.isInstance(inst);
            }
            String instanceOf = (String)this.fo.getAttribute(FolderPathLookup.ATTR_INSTANCE_OF);
            if (instanceOf != null) {
                for (String xface : instanceOf.split(",")) {
                    try {
                        if (!c.isAssignableFrom(Class.forName(xface, false, InstanceItem.loader()))) continue;
                        return true;
                    }
                    catch (ClassNotFoundException x) {
                        LOG.log(Level.FINE, "could not load " + xface + " for " + this.fo.getPath(), x);
                    }
                }
                return false;
            }
            return c.isAssignableFrom(this.getType());
        }

        protected boolean creatorOf(Object obj) {
            Reference<Object> refL = this.getRef();
            return refL != null ? refL.get() == obj : false;
        }

        public synchronized Object getInstance() {
            Reference<Object> refL = this.getRef();
            Object inst = null;
            if (refL != null && (inst = refL.get()) == null) {
                return FolderPathLookup.getInstanceItem(this.fo, this).getInstance();
            }
            if (inst == null && (inst = InstanceItem.createInstanceFor(this.fo, Object.class)) != null) {
                this.setRef(new Ref(inst));
            }
            return inst;
        }

        public Class<? extends Object> getType() {
            Class<? extends Object> type = InstanceItem.findTypeFor(this.fo);
            return type != null ? type : Void.class;
        }

        public String getId() {
            String s = this.fo.getPath();
            if (s.endsWith(".instance")) {
                s = s.substring(0, s.length() - ".instance".length());
            }
            return s;
        }

        public String getDisplayName() {
            String n = this.fo.getName();
            try {
                n = this.fo.getFileSystem().getDecorator().annotateName(n, Collections.singleton(this.fo));
            }
            catch (FileStateInvalidException ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
            }
            return n;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceItem other = (InstanceItem)obj;
            return this.fo == other.fo || this.fo != null && this.fo.equals(other.fo);
        }

        public int hashCode() {
            return this.fo.hashCode();
        }

        private static ClassLoader loader() {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = InstanceItem.class.getClassLoader();
            }
            return l;
        }

        static <T> T createInstanceFor(FileObject f, Class<T> resultType) {
            Object inst = f.getAttribute("instanceCreate");
            if (inst == null) {
                try {
                    Class<? extends Object> type = InstanceItem.findTypeFor(f);
                    if (type == null) {
                        return null;
                    }
                    inst = FolderPathLookup.createInstance(type);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return resultType.isInstance(inst) ? (T)resultType.cast(inst) : null;
        }

        private static Class<? extends Object> findTypeFor(FileObject f) {
            String clazz = InstanceItem.getClassName(f);
            if (clazz == null) {
                return null;
            }
            try {
                return Class.forName(clazz, false, InstanceItem.loader());
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
                return null;
            }
        }

        private static String getClassName(FileObject fo) {
            int last;
            Object attr = fo.getAttribute("instanceClass");
            if (attr instanceof String) {
                return BaseUtilities.translate((String)((String)attr));
            }
            if (attr != null) {
                LOG.warning("instanceClass was a " + attr.getClass().getName());
            }
            if ((attr = fo.getAttribute("instanceCreate")) != null) {
                return attr.getClass().getName();
            }
            Enumeration attributes = fo.getAttributes();
            while (attributes.hasMoreElements()) {
                if (!((String)attributes.nextElement()).equals("instanceCreate")) continue;
                return null;
            }
            String name = fo.getName();
            int first = name.indexOf(91) + 1;
            if (first != 0) {
                LOG.log(Level.WARNING, "Cannot understand {0}", fo);
            }
            if ((last = name.indexOf(93)) < 0) {
                last = name.length();
            }
            if (first < last) {
                name = name.substring(first, last);
            }
            name = name.replace('-', '.');
            name = BaseUtilities.translate((String)name);
            return name;
        }

        void release() {
            FolderPathLookup.releaseInstanceItem(this);
        }

        private final class Ref
        extends WeakReference<Object>
        implements Runnable {
            Ref(Object inst) {
                super(inst, BaseUtilities.activeReferenceQueue());
            }

            @Override
            public void run() {
                InstanceItem.this.release();
            }
        }
    }

    private static final class PairItem
    extends AbstractLookup.Pair<Object> {
        private final InstanceItem instanceItem;

        PairItem(FileObject fo) {
            this.instanceItem = FolderPathLookup.getInstanceItem(fo, null);
            assert (this.instanceItem != null) : "InstanceItem must not be null";
        }

        protected boolean instanceOf(Class<?> c) {
            return this.instanceItem.instanceOf(c);
        }

        protected boolean creatorOf(Object obj) {
            return this.instanceItem.creatorOf(obj);
        }

        public Object getInstance() {
            return this.instanceItem.getInstance();
        }

        public Class<? extends Object> getType() {
            return this.instanceItem.getType();
        }

        public String getId() {
            return this.instanceItem.getId();
        }

        public String getDisplayName() {
            return this.instanceItem.getDisplayName();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            PairItem other = (PairItem)((Object)obj);
            return this.instanceItem.equals(other.instanceItem);
        }

        public int hashCode() {
            int hash = 3;
            hash = 11 * hash + this.instanceItem.hashCode();
            return hash;
        }
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FolderPathLookup.this.rebuild();
        }
    }
}

