/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Function;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.View;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCFunction;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCProcedure;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCTable;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCView;
import org.netbeans.modules.db.metadata.model.spi.SchemaImplementation;

public class JDBCSchema
extends SchemaImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCSchema.class.getName());
    protected final JDBCCatalog jdbcCatalog;
    protected final String name;
    protected final boolean _default;
    protected final boolean synthetic;
    protected Map<String, Table> tables;
    protected Map<String, View> views;
    protected Map<String, Procedure> procedures;
    protected Map<String, Function> functions;

    public JDBCSchema(JDBCCatalog jdbcCatalog, String name, boolean _default, boolean synthetic) {
        this.jdbcCatalog = jdbcCatalog;
        this.name = name;
        this._default = _default;
        this.synthetic = synthetic;
    }

    @Override
    public final Catalog getParent() {
        return this.jdbcCatalog.getCatalog();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isDefault() {
        return this._default;
    }

    @Override
    public final boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public final Collection<Table> getTables() {
        return this.initTables().values();
    }

    @Override
    public final Table getTable(String name) {
        return MetadataUtilities.find(name, this.initTables());
    }

    @Override
    public View getView(String name) {
        return MetadataUtilities.find(name, this.initViews());
    }

    @Override
    public Collection<View> getViews() {
        return this.initViews().values();
    }

    @Override
    public Procedure getProcedure(String name) {
        return this.initProcedures().get(name);
    }

    @Override
    public Collection<Procedure> getProcedures() {
        return this.initProcedures().values();
    }

    @Override
    public Function getFunction(String name) {
        return this.initFunctions().get(name);
    }

    @Override
    public Collection<Function> getFunctions() {
        return this.initFunctions().values();
    }

    @Override
    public void refresh() {
        this.tables = null;
        this.views = null;
        this.procedures = null;
    }

    public String toString() {
        return "JDBCSchema[name='" + this.name + "',default=" + this._default + ",synthetic=" + this.synthetic + "]";
    }

    protected JDBCTable createJDBCTable(String name, boolean system) {
        return new JDBCTable(this, name, system);
    }

    protected JDBCProcedure createJDBCProcedure(String procedureName) {
        return new JDBCProcedure(this, procedureName);
    }

    protected JDBCFunction createJDBCFunction(String functionName) {
        return new JDBCFunction(this, functionName);
    }

    protected JDBCView createJDBCView(String viewName) {
        return new JDBCView(this, viewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() {
        LOGGER.log(Level.FINE, "Initializing tables in {0}", this);
        LinkedHashMap<String, Table> newTables = new LinkedHashMap<String, Table>();
        try {
            ResultSet rs = MetadataUtilities.getTables(this.jdbcCatalog.getJDBCMetadata().getDmd(), this.jdbcCatalog.getName(), this.name, "%", new String[]{"TABLE", "SYSTEM TABLE"});
            try {
                while (rs.next()) {
                    String type = MetadataUtilities.trimmed(rs.getString("TABLE_TYPE"));
                    String tableName = MetadataUtilities.trimmed(rs.getString("TABLE_NAME"));
                    Table table = this.createJDBCTable(tableName, type.contains("SYSTEM")).getTable();
                    newTables.put(tableName, table);
                    LOGGER.log(Level.FINE, "Created table {0}", table);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.tables = Collections.unmodifiableMap(newTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createViews() {
        LOGGER.log(Level.FINE, "Initializing views in {0}", this);
        LinkedHashMap<String, View> newViews = new LinkedHashMap<String, View>();
        try {
            ResultSet rs = MetadataUtilities.getTables(this.jdbcCatalog.getJDBCMetadata().getDmd(), this.jdbcCatalog.getName(), this.name, "%", new String[]{"VIEW"});
            try {
                while (rs.next()) {
                    String viewName = MetadataUtilities.trimmed(rs.getString("TABLE_NAME"));
                    View view = this.createJDBCView(viewName).getView();
                    newViews.put(viewName, view);
                    LOGGER.log(Level.FINE, "Created view {0}", view);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.views = Collections.unmodifiableMap(newViews);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProcedures() {
        LOGGER.log(Level.FINE, "Initializing procedures in {0}", this);
        LinkedHashMap<String, Procedure> newProcedures = new LinkedHashMap<String, Procedure>();
        try {
            ResultSet rs = MetadataUtilities.getProcedures(this.jdbcCatalog.getJDBCMetadata().getDmd(), this.jdbcCatalog.getName(), this.name, "%");
            try {
                while (rs.next()) {
                    String procedureName = MetadataUtilities.trimmed(rs.getString("PROCEDURE_NAME"));
                    Procedure procedure = this.createJDBCProcedure(procedureName).getProcedure();
                    newProcedures.put(procedureName, procedure);
                    LOGGER.log(Level.FINE, "Created procedure {0}", procedure);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.procedures = Collections.unmodifiableMap(newProcedures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFunctions() {
        LOGGER.log(Level.FINE, "Initializing functions in {0}", this);
        LinkedHashMap<String, Function> newProcedures = new LinkedHashMap<String, Function>();
        try {
            ResultSet rs = MetadataUtilities.getFunctions(this.jdbcCatalog.getJDBCMetadata().getDmd(), this.jdbcCatalog.getName(), this.name, "%");
            try {
                while (rs.next()) {
                    String functionName = MetadataUtilities.trimmed(rs.getString("FUNCTION_NAME"));
                    Function function = this.createJDBCFunction(functionName).getFunction();
                    newProcedures.put(functionName, function);
                    LOGGER.log(Level.FINE, "Created function {0}", function);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.functions = Collections.unmodifiableMap(newProcedures);
    }

    private Map<String, Table> initTables() {
        if (this.tables != null) {
            return this.tables;
        }
        this.createTables();
        return this.tables;
    }

    public final JDBCCatalog getJDBCCatalog() {
        return this.jdbcCatalog;
    }

    private Map<String, View> initViews() {
        if (this.views != null) {
            return this.views;
        }
        this.createViews();
        return this.views;
    }

    private Map<String, Procedure> initProcedures() {
        if (this.procedures != null) {
            return this.procedures;
        }
        this.createProcedures();
        return this.procedures;
    }

    private Map<String, Function> initFunctions() {
        if (this.functions != null) {
            return this.functions;
        }
        this.createFunctions();
        return this.functions;
    }
}

