/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;

public final class MathUtil {
    public static final long BYTES_PER_MB = 0x100000L;
    public static final int MILLI_SEC_PER_DAY = 86400000;
    public static final double DOUBLE_EPSILON = 1.0E-6;

    public static Integer dup(Integer intObj) {
        Integer newInt = intObj != null ? new Integer(intObj) : null;
        return newInt;
    }

    public static Rectangle2D dupRect(Rectangle2D rect) {
        Rectangle2D.Double dup = rect != null ? new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()) : null;
        return dup;
    }

    public static int round(double d) {
        long l = Math.round(d);
        int i = (int)l;
        return i;
    }

    public static boolean doubleEquals(double doubleA, double doubleB) {
        return Math.abs(doubleA - doubleB) < 1.0E-6;
    }

    public static Point getRectCenter(Rectangle rect) {
        Point pt = new Point((int)rect.getCenterX(), (int)rect.getCenterY());
        return pt;
    }

    public static int getDaysElapsed(Calendar calA, Calendar calB) {
        long msB = calB.getTimeInMillis();
        long msA = calA.getTimeInMillis();
        long msElapsed = msB - msA;
        int daysElapsed = (int)(msElapsed / 86400000L);
        return daysElapsed;
    }

    public static Rectangle getMixMaxRect(Rectangle rectA, Rectangle rectB) {
        int minX = (int)Math.min(rectA.getMinX(), rectB.getMinX());
        int minY = (int)Math.min(rectA.getMinY(), rectB.getMinY());
        int maxX = (int)Math.max(rectA.getMaxX(), rectB.getMaxX());
        int maxY = (int)Math.max(rectA.getMaxY(), rectB.getMaxY());
        int width = maxX - minX;
        int height = maxY - minY;
        return new Rectangle(minX, minY, width, height);
    }

    public static boolean isEquivalent(Object objA, Object objB) {
        if (objA == null && objB == null) {
            return true;
        }
        if (objA == null && objB != null) {
            return false;
        }
        if (objA != null && objB == null) {
            return false;
        }
        return objA.equals(objB);
    }

    public static int getVertLineLength(Line2D line) {
        double lenDbl = Math.abs(line.getY2() - line.getY1());
        int len = (int)lenDbl;
        return len;
    }

    public static int getHorzLineLength(Line2D line) {
        double lenDbl = Math.abs(line.getX2() - line.getX1());
        int len = (int)lenDbl;
        return len;
    }

    public static int compareNullables(Object objA, Object objB) {
        if (objA == null && objB == null) {
            return 0;
        }
        if (objA == null && objB != null) {
            return -1;
        }
        if (objA != null && objB == null) {
            return 1;
        }
        if (!objB.getClass().equals(objA.getClass())) {
            return 0;
        }
        if (!(objA instanceof Comparable)) {
            return 0;
        }
        if (!(objB instanceof Comparable)) {
            return 0;
        }
        Comparable compA = (Comparable)objA;
        Comparable compB = (Comparable)objB;
        return compA.compareTo(objB);
    }

    public static int compareNulls2(Object objA, Object objB) {
        if (objA != null && objB == null) {
            return -1;
        }
        if (objA == null && objB != null) {
            return 1;
        }
        return 0;
    }

    public static Point translate(Point pt, int dx, int dy) {
        Point newPt = new Point(pt.x + dx, pt.y + dy);
        return newPt;
    }

    public static Point getOrigin(Rectangle2D rect2D) {
        Point pt = new Point((int)rect2D.getX(), (int)rect2D.getY());
        return pt;
    }

    public static boolean getIsBetween(int min, int max, int value) {
        return value <= max && value >= min;
    }

    public static void checkGc() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        System.out.println("MathUtil.gc()");
    }

    public static double getMegaBytes(long bytes) {
        return (double)bytes / 1048576.0;
    }
}

