/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom.presets;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.AddRemovePanel;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.sketch.zoom.ZoomValidator;
import com.harrand.sketch.zoom.presets.ZoomPresetsCtrl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ZoomPresetsPanel
extends JPanel {
    private final ZoomPresetsCtrl ctrl;
    private final AddRemovePanel addRemovePanel = new AddRemovePanel();
    private final JLabel listLbl = new JLabel("Specify zoom levels, in percents, for zooming in and out of diagrams.");
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList list = new JList(this.listModel);
    private final HeaderPanel header = new HeaderPanel("Diagram Zoom Presets", 5, true);
    private final ZoomValidator zoomValidator = new ZoomValidator();
    private JScrollPane scrollPane;
    public static final String TITLE = "Zoom Presets";

    public ZoomPresetsPanel(ZoomPresetsCtrl ctrl) {
        this.ctrl = ctrl;
        this.init();
        this.refresh();
    }

    private void init() {
        this.setupGui();
        this.loadData();
        this.buildListeners();
    }

    private void refresh() {
        this.loadData();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.scrollPane = new JScrollPane(this.list);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.header, "North");
        this.add(this.getCenterPanel(), "Center");
    }

    private Component getCenterPanel() {
        this.scrollPane = new JScrollPane(this.list);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)this.listLbl, "North");
        panel.add((Component)this.getMiddlePanel(), "Center");
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getMiddlePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.getScrollPanel());
        panel.add(this.getAddRemPanel());
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private JPanel getScrollPanel() {
        this.scrollPane = new JScrollPane(this.list);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.scrollPane, "Center");
        return panel;
    }

    private JPanel getAddRemPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.addRemovePanel);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private void setCosmetics() {
        GuiHelper.addEmptyBorder(this);
        this.setAddRemoveBorder();
        this.listLbl.setAlignmentX(0.0f);
        this.listLbl.setHorizontalTextPosition(2);
    }

    private void buildListeners() {
        this.addRemovePanel.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomPresetsPanel.this.promptAddPreset();
            }
        });
        this.addRemovePanel.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomPresetsPanel.this.removePresets();
            }
        });
    }

    private void promptAddPreset() {
        Integer zoomPercent;
        String intStr = JOptionPane.showInputDialog(NbUtil.getMainWindow(), "Add Zoom Preset", "Zoom Preset", 3);
        if (intStr != null && (zoomPercent = this.zoomValidator.parseLevel(intStr)) != null && this.zoomValidator.isLevelInRange(zoomPercent)) {
            this.ctrl.addPreset(zoomPercent);
            this.refresh();
        }
    }

    private void removePresets() {
        Object[] selectedValues = this.list.getSelectedValues();
        if (selectedValues.length > 0) {
            for (int i = 0; i < selectedValues.length; ++i) {
                String presetStr = (String)selectedValues[i];
                int preset = Integer.parseInt(presetStr);
                this.ctrl.removePreset(preset);
            }
            this.refresh();
        } else {
            GuiMessageHelper.showInputErrMsg(null, "No Zoom Selected", "Please select at least one zoom level to remove.");
        }
    }

    private void loadData() {
        this.listModel.clear();
        if (this.ctrl == null) {
            return;
        }
        for (Integer presetObj : this.ctrl.getPresets()) {
            this.listModel.addElement(presetObj.toString());
        }
    }

    private void setAddRemoveBorder() {
        int th = 5;
        this.addRemovePanel.setBorder(BorderFactory.createEmptyBorder(th, th, th, th));
    }
}

