/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.IZoomable;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.Icons;
import com.harrand.coregui.IntFrame;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.listener.BasicInternalFrameListener;
import com.harrand.coregui.text.IntegerTextField;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.zoom.IZoomablePanel;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameListener;

@Deprecated
public final class ZoomToolbar
extends JToolBar
implements IObserver {
    private List zoomables_;
    private CommandChain commandChain_;
    private BasicInternalFrameListener frameListener_;
    private ActionListener lisZoomIn_;
    private ActionListener lisZoomOut_;
    private FocusListener lisTextFocus_;
    private JButton btnZoomIn_ = new JButton();
    private JButton btnZoomOut_ = new JButton();
    private JTextField txtZoom_ = new IntegerTextField(0, 4);
    private JLabel lblPercent_ = new JLabel("%");
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    public ZoomToolbar(CommandChain commandChain) {
        this.commandChain_ = commandChain;
        this.initComponents();
        this.addComponents();
        this.enableButtons();
        this.setCosmetics();
        this.buildListeners();
        this.addListeners();
        this.setNames();
        this.refresh();
    }

    public void setZoomables(List zoomables) {
        this.zoomables_ = zoomables;
        if (this.zoomables_ != null) {
            for (IZoomable zoomable : this.zoomables_) {
                if (!(zoomable instanceof IObservable)) continue;
                ((IObservable)((Object)zoomable)).addObserver(this);
            }
        }
        this.refresh();
    }

    public void setInternalFrameListener(BasicInternalFrameListener listener) {
        this.frameListener_ = listener;
        this.frameListener_.addObserver(this);
    }

    private void buildListeners() {
        this.lisZoomIn_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                double nextLevel = ZoomToolbar.this.getNextZoomLevel(1);
                ZoomToolbar.this.doZoomCommand(nextLevel);
            }
        };
        this.lisZoomOut_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                double nextLevel = ZoomToolbar.this.getNextZoomLevel(0);
                ZoomToolbar.this.doZoomCommand(nextLevel);
            }
        };
    }

    private void doZoomCommand(double newLevel) {
    }

    private double getNextZoomLevel(int direction) {
        double level = 1.0;
        IZoomable zoomable = this.getFirstZoomable();
        if (zoomable != null) {
            level = zoomable.getZoom().getNextZoom(direction).getLevel();
        }
        return level;
    }

    private void addComponents() {
        this.add(this.btnZoomIn_);
        this.add(this.btnZoomOut_);
        this.add(this.txtZoom_);
        this.add(this.lblPercent_);
    }

    private IZoomable getFirstZoomable() {
        IZoomable zoomable = null;
        if (this.zoomables_ != null && !this.zoomables_.isEmpty()) {
            zoomable = (IZoomable)this.zoomables_.get(0);
        }
        return zoomable;
    }

    private void enableButtons() {
        IZoomable zoomable = this.getFirstZoomable();
        if (zoomable != null) {
            double currentLevel = zoomable.getZoom().getLevel();
            this.btnZoomIn_.setEnabled(currentLevel < Zoomer.getMaxZoomLevel());
            this.btnZoomOut_.setEnabled(currentLevel > Zoomer.getMinZoomLevel());
        } else {
            this.btnZoomIn_.setEnabled(false);
            this.btnZoomOut_.setEnabled(false);
        }
    }

    private void addListeners() {
        this.lisTextFocus_ = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                if (ZoomToolbar.this.txtZoom_.isEnabled()) {
                    ZoomToolbar.this.validateField(ZoomToolbar.this.txtZoom_);
                }
            }

            @Override
            public void focusGained(FocusEvent evt) {
                ZoomToolbar.this.txtZoom_.selectAll();
            }
        };
        this.txtZoom_.addFocusListener(this.lisTextFocus_);
        this.txtZoom_.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ZoomToolbar.this.validateField(ZoomToolbar.this.txtZoom_);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.addButtonListeners();
    }

    private void addButtonListeners() {
        this.btnZoomIn_.addActionListener(this.lisZoomIn_);
        this.btnZoomOut_.addActionListener(this.lisZoomOut_);
        this.registerKeyboardAction(this.lisZoomIn_, KeyStroke.getKeyStroke(107, 2, false), 2);
        this.registerKeyboardAction(this.lisZoomOut_, KeyStroke.getKeyStroke(109, 2, false), 2);
    }

    private void setCosmetics() {
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.btnZoomIn_.setText("");
        this.btnZoomOut_.setText("");
        this.btnZoomIn_.setIcon(Icons.ZOOM_IN);
        this.btnZoomOut_.setIcon(Icons.ZOOM_OUT);
        this.btnZoomIn_.setToolTipText(FileHelper.getRes("zoom.in.label"));
        this.btnZoomOut_.setToolTipText(FileHelper.getRes("zoom.out.label"));
        this.txtZoom_.setHorizontalAlignment(4);
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.txtZoom_);
        this.themeCtrl_.process(this.lblPercent_);
        this.txtZoom_.setMaximumSize(this.txtZoom_.getPreferredSize());
        this.lblPercent_.setMaximumSize(this.lblPercent_.getPreferredSize());
    }

    private void setNames() {
        this.btnZoomIn_.setName("btnZoomIn");
        this.btnZoomOut_.setName("btnZoomOut");
        this.txtZoom_.setName("txtZoom");
    }

    private void refresh() {
        this.refreshText();
        this.refreshButtons();
    }

    private void refreshText() {
        String text;
        IZoomable zoomable = this.getFirstZoomable();
        if (zoomable != null) {
            this.txtZoom_.setEnabled(true);
            double level = zoomable.getZoom().getLevel();
            text = Integer.toString((int)(100.0 * level));
        } else {
            text = "";
            this.txtZoom_.setEnabled(false);
        }
        this.txtZoom_.setText(text);
    }

    private void refreshButtons() {
        this.enableButtons();
    }

    public void validateField(JTextField field) {
        ITestResult result = this.validateText(field.getText());
        if (result.getPassed()) {
            try {
                int percent = Integer.parseInt(field.getText());
                this.doZoomCommand((double)percent / 100.0);
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
            }
        } else {
            this.txtZoom_.removeFocusListener(this.lisTextFocus_);
            GuiMessageHelper.showInputErrMsg(field, result.getSummary(), result.getDetail());
            this.txtZoom_.addFocusListener(this.lisTextFocus_);
        }
    }

    private ITestResult validateText(String text) {
        String detail;
        boolean passed;
        block5: {
            passed = false;
            if (text.length() > 0) {
                try {
                    int percent = Integer.parseInt(text);
                    if (Zoomer.isWithinRange((double)percent / 100.0)) {
                        passed = true;
                        detail = FileHelper.getRes("data.entry.valid.msg");
                        break block5;
                    }
                    detail = Zoomer.getOutOfRangeMsg(percent);
                }
                catch (Exception e) {
                    detail = e.getMessage();
                }
            } else {
                detail = FileHelper.getRes("err.zoom.text.empty");
            }
        }
        return new DataEntryResult(passed, detail);
    }

    private void initComponents() {
    }

    @Override
    public void update(UpdateChain chain) {
        IntFrame activeFrame;
        long start = System.currentTimeMillis();
        if (chain.hasInteface(InternalFrameListener.class.getName()) && (activeFrame = (IntFrame)this.frameListener_.getActiveFrame()) != null && activeFrame.getMainPanel() instanceof IZoomablePanel) {
            IZoomablePanel zoomablePanel = (IZoomablePanel)((Object)activeFrame.getMainPanel());
            zoomablePanel.setZoomToolbar(this);
        }
        if (chain.hasClassName(Diagram.getClassName())) {
            this.refresh();
        }
    }
}

