/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.IDiagramSrv;
import com.harrand.sketch.zoom.ZoomCtrl;
import com.harrand.util.LogUtil;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoomCtrlMgr {
    private IDiagramSrv diagramSrv_;
    private Map zoomCtrls_;

    public ZoomCtrlMgr(IDiagramSrv diagramSrv) {
        this.setDiagramSrv(diagramSrv);
    }

    public void setDiagramSrv(IDiagramSrv diagramSrv) {
        this.diagramSrv_ = diagramSrv;
        this.zoomCtrls_ = new HashMap();
        if (this.diagramSrv_ != null) {
            for (Diagram diagram : this.diagramSrv_.getDiagrams()) {
                ZoomCtrl ctrl = diagram.getZoomCtrl();
                this.zoomCtrls_.put(diagram.getName(), ctrl);
            }
        }
    }

    public Rectangle2D getZoomedRect(Diagram diagram, double newZm, Rectangle2D currentRect) {
        Rectangle2D newRect;
        ZoomCtrl ctrl = this.getZoomCtrl(diagram);
        if (ctrl != null) {
            newRect = ctrl.getZoomedRect(newZm, currentRect);
        } else {
            LogUtil.logErr("ZoomCtrlMgr: ctrl is NULL, diagram: " + diagram.getName());
            newRect = currentRect;
        }
        return newRect;
    }

    public void refreshCtrls() {
        HashMap<String, ZoomCtrl> newCtrls = new HashMap<String, ZoomCtrl>();
        if (this.diagramSrv_ != null) {
            List diagramNms = StrHelper.getNamedNms(this.diagramSrv_.getDiagrams());
            for (String diagramNm : diagramNms) {
                ZoomCtrl ctrl = this.zoomCtrls_.keySet().contains(diagramNm) ? (ZoomCtrl)this.zoomCtrls_.get(diagramNm) : new ZoomCtrl(this.diagramSrv_.getDiagram(diagramNm));
                newCtrls.put(diagramNm, ctrl);
            }
        }
        this.zoomCtrls_ = newCtrls;
    }

    public void clearIdealRect(Diagram diagram) {
        ZoomCtrl ctrl = this.getZoomCtrl(diagram);
        if (ctrl != null) {
            ctrl.reset();
        }
    }

    public void setZoomingInProgress(Diagram diagram, boolean inProgress) {
        ZoomCtrl ctrl = this.getZoomCtrl(diagram);
        if (ctrl != null) {
            ctrl.setZoomingInProgress(inProgress);
        }
    }

    public int getCtrlCount() {
        return this.zoomCtrls_.size();
    }

    private ZoomCtrl getZoomCtrl(Diagram diagram) {
        String nm = diagram.getName();
        ZoomCtrl ctrl = (ZoomCtrl)this.zoomCtrls_.get(nm);
        if (ctrl == null) {
            LogUtil.logErr("ZoomCtrlMgr.Ctrl not found: " + nm);
        }
        return ctrl;
    }
}

