/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.zoom.ZoomOriginStorage;
import com.harrand.util.MathUtil;
import java.awt.geom.Rectangle2D;

public class ZoomCtrl {
    private Diagram diagram_;
    private double lastZm_;
    private Rectangle2D idealRect_;
    private Rectangle2D newRect_;
    private boolean zoomingInProgress_ = false;
    private Rectangle2D lastZmRect;

    public ZoomCtrl(Diagram diagram) {
        this.setDiagram(diagram);
    }

    private void setDiagram(Diagram diagram) {
        this.diagram_ = diagram;
        this.lastZm_ = this.diagram_.getZoom().getLevel();
    }

    public Rectangle2D getZoomedRect(double newZm, Rectangle2D currentRect) {
        this.doCalcs(newZm, currentRect);
        this.lastZm_ = newZm;
        return this.newRect_;
    }

    public void reset() {
        if (!this.zoomingInProgress_) {
            this.idealRect_ = null;
            this.diagram_.getZoomOriginStorage().clear();
        }
    }

    public void setZoomingInProgress(boolean zoomingInProgress) {
        this.zoomingInProgress_ = zoomingInProgress;
    }

    private void doCalcs(double newZm, Rectangle2D currentRect) {
        ZoomOriginStorage zoomOriginStorage = this.diagram_.getZoomOriginStorage();
        Rectangle2D storedRect = zoomOriginStorage.getZoomRect(new Zoom(newZm));
        if (storedRect == null) {
            double zoomRatio = newZm / this.lastZm_;
            Rectangle2D lastRect = this.idealRect_ != null ? this.idealRect_ : currentRect;
            Rectangle2D zmRect = Zoomer.zoomCentered(lastRect, zoomRatio, zoomOriginStorage, new Zoom(newZm));
            this.idealRect_ = Zoomer.zoom(zmRect, zoomRatio);
            Rectangle2D bounds = MathUtil.dupRect(this.diagram_.getBounds2D());
            Rectangle2D.Double withMargins = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() + 200.0, bounds.getHeight() + 200.0);
            Rectangle2D zmBounds = Zoomer.zoom(withMargins, newZm);
            boolean inBounds = zmBounds.contains(this.idealRect_.getX(), this.idealRect_.getY(), this.idealRect_.getWidth(), this.idealRect_.getHeight());
            if (inBounds) {
                this.newRect_ = MathUtil.dupRect(this.idealRect_);
                zoomOriginStorage.clear();
            } else {
                this.newRect_ = this.getInBoundsRect(this.idealRect_, zmBounds);
                zoomOriginStorage.putZoomRect(new Zoom(this.lastZm_), this.lastZmRect);
                zoomOriginStorage.putZoomRect(new Zoom(newZm), this.newRect_);
            }
        } else {
            this.newRect_ = storedRect;
            this.idealRect_ = null;
        }
        this.lastZmRect = MathUtil.dupRect(this.newRect_);
    }

    private Rectangle2D getInBoundsRect(Rectangle2D rect, Rectangle2D bounds) {
        boolean oversized;
        double rectX = rect.getX();
        double rectY = rect.getY();
        double rectW = rect.getWidth();
        double rectH = rect.getHeight();
        double rectMaxX = rect.getMaxX();
        double rectMaxY = rect.getMaxY();
        double boundsMaxX = bounds.getMaxX();
        double boundsMaxY = bounds.getMaxY();
        double boundsH = bounds.getHeight();
        double boundsW = bounds.getWidth();
        boolean bl = oversized = rectW >= boundsW || rectH >= boundsH;
        if (oversized) {
            return this.getMaxRect(bounds);
        }
        double x = rectX;
        double y = rectY;
        if (rectMaxX > boundsMaxX) {
            x = rectX - (rectMaxX - boundsMaxX);
        }
        if (rectMaxY > boundsMaxY) {
            y = rectY - (rectMaxY - boundsMaxY);
        }
        if (rectX < 0.0) {
            x = 0.0;
        }
        if (rectY < 0.0) {
            y = 0.0;
        }
        Rectangle2D.Double inBounds = new Rectangle2D.Double(x, y, rect.getWidth(), rect.getHeight());
        return inBounds;
    }

    private Rectangle2D getMaxRect(Rectangle2D bounds) {
        Rectangle2D.Double maxRect = new Rectangle2D.Double(0.0, 0.0, bounds.getWidth() - 2.0, bounds.getHeight() - 2.0);
        return maxRect;
    }
}

