/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom;

import com.harrand.coreclasses.zoom.IZoomable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public final class ZoomCommand
extends Command {
    private String name_;
    private List zoomables_;
    private double newLevel_;
    private Zoom oldZoom_;

    public ZoomCommand(IZoomable zoomable, int direction) {
        double newLevel = this.getNextZm(zoomable, direction);
        List zoomables = this.buildZoomables(zoomable);
        this.init(zoomables, newLevel, Command.getStateDo());
    }

    public ZoomCommand(IZoomable zoomable, double newLevel) {
        this.init(this.buildZoomables(zoomable), newLevel, Command.getStateDo());
    }

    private ZoomCommand(List zoomables, double newLevel, int state) {
        this.init(zoomables, newLevel, state);
    }

    private double getNextZm(IZoomable zoomable, int direction) {
        Zoom zoom = zoomable.getZoom();
        double newLevel = zoom.getNextZoom(direction).getLevel();
        return newLevel;
    }

    private List buildZoomables(IZoomable zoomable) {
        ArrayList<IZoomable> zoomables = new ArrayList<IZoomable>();
        zoomables.add(zoomable);
        return zoomables;
    }

    private void init(List zoomables, double newLevel, int state) {
        this.zoomables_ = zoomables;
        this.newLevel_ = newLevel;
        if (this.zoomables_.size() > 0) {
            IZoomable aZoomable = (IZoomable)this.zoomables_.get(0);
            this.oldZoom_ = aZoomable.getZoom();
        } else {
            LogUtil.logErr("ZoomCommand.zoomables is empty.");
            this.oldZoom_ = new Zoom(1.0);
        }
        this.setState(state);
        this.setProps();
    }

    @Override
    protected void setProps() {
        this.setName();
        this.putValue("Name", this.getDoPrefix() + this.name_);
        this.putValue("ShortDescription", this.getDoPrefix() + this.toString());
        this.putValue("LongDescription", this.getDoPrefix() + this.toString());
        ImageIcon icon = this.isZoomIn() ? Icons.ZOOM_IN : Icons.ZOOM_OUT;
        this.putValue("SmallIcon", icon);
        this.putValue("AcceleratorKey", this.getAcceleratorStroke());
    }

    private KeyStroke getAcceleratorStroke() {
        KeyStroke keyStroke = this.isZoomIn() ? KeyStroke.getKeyStroke(521, 128) : KeyStroke.getKeyStroke(45, 2);
        return keyStroke;
    }

    private boolean isZoomIn() {
        boolean b = this.newLevel_ >= this.oldZoom_.getLevel();
        return b;
    }

    private void setName() {
        this.name_ = this.isZoomIn() ? FileHelper.getResource("zoom.in.label") : FileHelper.getResource("zoom.out.label");
    }

    @Override
    protected void execute() {
        for (IZoomable zoomable : this.zoomables_) {
            zoomable.setZoom(new Zoom(this.newLevel_));
        }
    }

    @Override
    protected void undo() {
        for (IZoomable zoomable : this.zoomables_) {
            zoomable.setZoom(this.oldZoom_);
        }
    }

    public String toString() {
        return this.name_ + " (" + FileHelper.getRes("to") + " " + Integer.toString((int)(this.newLevel_ * 100.0)) + "%)";
    }

    @Override
    public Command duplicate() {
        ZoomCommand cmdNew = new ZoomCommand(this.zoomables_, this.newLevel_, this.getState());
        cmdNew.oldZoom_ = this.oldZoom_;
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

