/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.glyph;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.glyph.HeaderGlyph;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.xml.svg.bldr.basic.SvgGradientBldr;
import com.harrand.sketch.xml.svg.bldr.basic.SvgRectBldr;
import com.harrand.sketch.xml.svg.bldr.basic.SvgTextBldr;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgHeaderGlyphBldr
implements ISvgShape {
    private HeaderGlyph headerGlyph;
    private Point coordSpace = new Point();
    private Rectangle glyphRect;
    private String text;
    private Point textOrigin;
    private GlyphImage glyphImg;
    private Color color;
    private int radius;
    private Document doc;

    public SvgHeaderGlyphBldr(HeaderGlyph headerGlyph) {
        this.headerGlyph = headerGlyph;
        this.glyphRect = this.headerGlyph.getRect();
        this.radius = this.headerGlyph.getContainingRectRadius();
        this.color = this.headerGlyph.getColor();
        this.glyphImg = this.headerGlyph.getGlyphImg();
        this.text = this.headerGlyph.getText();
        this.textOrigin = this.headerGlyph.getTextOrigin();
        this.coordSpace = this.headerGlyph.getCoordSpace();
    }

    @Override
    public Element getSvgElm(Document doc) {
        this.setDoc(doc);
        Element elmGroup = XmlHelper.createElementSimple(doc, "g", "");
        elmGroup.appendChild(this.getTopRectElm());
        elmGroup.appendChild(this.getBottomRectElm());
        elmGroup.appendChild(this.getTextElm());
        this.checkAddIconElm(elmGroup);
        return elmGroup;
    }

    private int getSubRectHeight() {
        return (int)this.glyphRect.getHeight() - this.radius;
    }

    private void setDoc(Document doc) {
        this.doc = doc;
    }

    private Element getRectElm(RoundRectangle2D roundRect) {
        SvgRectBldr elmBldr = new SvgRectBldr(this.doc);
        RoundRectangle2D absRect = GeometryHelper.move(roundRect, this.coordSpace);
        EnhancedShape eShape = new EnhancedShape(absRect, this.color);
        eShape.setIsStroked(false);
        Element elm = elmBldr.buildElmFromRoundRect(eShape, this.getGradientIdStr());
        return elm;
    }

    private Element getTopRectElm() {
        int height = this.getSubRectHeight();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(this.glyphRect.getX() - 0.5, this.glyphRect.getY() - 0.5, this.glyphRect.getWidth(), height, this.radius, this.radius);
        return this.getRectElm(rect);
    }

    private Element getBottomRectElm() {
        int height = this.getSubRectHeight();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(this.glyphRect.getX() - 0.5, this.glyphRect.getY() + (double)this.radius - 0.5, this.glyphRect.getWidth(), height, 0.0, 0.0);
        return this.getRectElm(rect);
    }

    private Element getTextElm() {
        SvgTextBldr elmBldr = new SvgTextBldr(this.doc);
        Point pt = new Point(this.coordSpace.x + this.textOrigin.x, this.coordSpace.y + this.textOrigin.y);
        Element elm = elmBldr.buildElm(this.text, pt, true);
        return elm;
    }

    public Element getGradientElm(Document doc) {
        this.setDoc(doc);
        SvgGradientBldr elmBldr = new SvgGradientBldr(doc);
        return elmBldr.buildElm(Color.WHITE, this.color);
    }

    public String getGradientIdStr() {
        return StrHelper.getGradientIdString(Color.WHITE, this.color);
    }

    private void checkAddIconElm(Element elmGroup) {
        if (this.glyphImg != null) {
            elmGroup.appendChild(this.glyphImg.getSvgElm(this.doc));
        }
    }

    private void buildSvgRects() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

