/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.basic;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgRectBldr {
    private Document doc;
    private EnhancedShape eShape;
    private String gradientIdStr;
    private double strokeWidth = 0.5;
    public static final String RECT_NM = "rect";
    public static final String NO_GRADIENT_VALUE = "fill:rgb";
    public static final String GRADIENT_PREFIX = "fill:url(#";

    public SvgRectBldr(Document doc) {
        this.doc = doc;
    }

    public void setStrokeWidth(double strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public Element buildElmFromRoundRect(EnhancedShape eShape, String gradientIdStr) {
        RoundRectangle2D roundRect = (RoundRectangle2D)eShape.getShape();
        this.initValues(eShape, gradientIdStr);
        Element elm = this.getRectElm(roundRect);
        return elm;
    }

    public Element buildElmFromSquaredRect(EnhancedShape eShape, String gradientIdStr) {
        Rectangle2D rect = (Rectangle2D)eShape.getShape();
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), 0.0, 0.0);
        this.initValues(eShape, gradientIdStr);
        Element elm = this.getRectElm(roundRect);
        return elm;
    }

    private void initValues(EnhancedShape eShape, String gradientIdStr) {
        this.eShape = eShape;
        this.setGradientIdStr(gradientIdStr);
    }

    private Element getRectElm(RoundRectangle2D roundRect) {
        Element elm = XmlHelper.createElementSimple(this.doc, RECT_NM, "");
        XmlHelper.setAttr(elm, "x", roundRect.getX());
        XmlHelper.setAttr(elm, "y", roundRect.getY());
        XmlHelper.setAttr(elm, "rx", 0.64 * roundRect.getArcWidth());
        XmlHelper.setAttr(elm, "ry", 0.64 * roundRect.getArcHeight());
        XmlHelper.setAttr(elm, "width", roundRect.getWidth());
        XmlHelper.setAttr(elm, "height", roundRect.getHeight());
        elm.setAttribute("style", this.getStyleValue());
        return elm;
    }

    private void setGradientIdStr(String gradientIdStr) {
        this.gradientIdStr = gradientIdStr;
    }

    private String getStyleValue() {
        String styleStr = this.getFillValue() + this.getStrokeValue();
        return styleStr;
    }

    private String getFillValue() {
        if (this.gradientIdStr != null) {
            return GRADIENT_PREFIX + this.gradientIdStr + ");";
        }
        Color fillColor = this.eShape.getFillColor();
        return NO_GRADIENT_VALUE + StrHelper.getRgbCsv(fillColor) + ";" + this.getSvgOpacityStr(fillColor, "fill");
    }

    private String getStrokeValue() {
        if (this.eShape.getIsStroked()) {
            Color strokeColor = this.eShape.getStrokeColor();
            return "stroke:rgb" + StrHelper.getRgbCsv(strokeColor) + ";stroke-width:" + Double.toString(this.strokeWidth) + ";" + this.getSvgOpacityStr(strokeColor, "stroke");
        }
        return "";
    }

    public String getSvgOpacityStr(Color color, String cmdPrefix) {
        return Colors.getSvgOpacityStr(color, cmdPrefix);
    }
}

