/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.basic;

import com.harrand.sketch.xml.svg.common.SvgUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Polygon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgPolygonBldr {
    private Document doc;

    public SvgPolygonBldr(Document doc) {
        this.doc = doc;
    }

    public Element buildElm(Polygon polygon, Color strokeColor, Color fillColor) {
        Element elm = XmlHelper.createElementSimple(this.doc, "path", "");
        elm.setAttribute("d", this.getdStr(polygon));
        elm.setAttribute("style", this.getStyleValue(strokeColor, fillColor));
        return elm;
    }

    private String getdStr(Polygon polygon) {
        StringBuilder sb = new StringBuilder();
        int firstX = -1;
        int firstY = -1;
        int count = polygon.npoints;
        for (int i = 0; i < count; ++i) {
            int x = polygon.xpoints[i];
            int y = polygon.ypoints[i];
            if (i == 0) {
                firstX = x;
                firstY = y;
                sb.append("M ");
            } else {
                sb.append("L ");
            }
            sb.append(x).append(" ").append(y).append(" ");
        }
        sb.append("L ").append(firstX).append(" ").append(firstY);
        return sb.toString();
    }

    private String getStyleValue(Color strokeColor, Color fillColor) {
        String strokeColorStr = SvgUtil.getStrokeColorStr(strokeColor);
        String fillStr = SvgUtil.getFillStr(fillColor);
        return strokeColorStr + fillStr;
    }
}

