/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.basic;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgGradientBldr {
    private Document doc;
    public static final String LINEAR_GRADIENT_NM = "linearGradient";
    public static final String STOP_NM = "stop";
    public static final String OFFSET_NM = "offset";

    public SvgGradientBldr(Document doc) {
        this.doc = doc;
    }

    public Element buildElm(Color colorA, Color colorB) {
        return this.buildElm(colorA, colorB, true, StrHelper.getGradientIdString(colorA, colorB));
    }

    public Element buildElm(Color colorA, Color colorB, boolean isHorz, String gradientId) {
        Element elm = XmlHelper.createElementSimple(this.doc, LINEAR_GRADIENT_NM, "");
        elm.setAttribute("id", gradientId);
        elm.setAttribute("x1", "0%");
        elm.setAttribute("y1", "0%");
        String x2Value = isHorz ? "100%" : "0%";
        String y2Value = isHorz ? "0%" : "100%";
        elm.setAttribute("x2", x2Value);
        elm.setAttribute("y2", y2Value);
        Element stopElmA = XmlHelper.createElementSimple(this.doc, STOP_NM, "");
        stopElmA.setAttribute("style", this.getStyleValue(colorA));
        stopElmA.setAttribute(OFFSET_NM, "0%");
        elm.appendChild(stopElmA);
        Element stopElmB = XmlHelper.createElementSimple(this.doc, STOP_NM, "");
        stopElmB.setAttribute("style", this.getStyleValue(colorB));
        stopElmB.setAttribute(OFFSET_NM, "100%");
        elm.appendChild(stopElmB);
        return elm;
    }

    private String getStyleValue(Color color) {
        return "stop-color:rgb" + StrHelper.getRgbCsv(color) + ";stop-opacity:1";
    }
}

