/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.basic;

import com.harrand.sketch.xml.svg.common.SvgUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgCircleBldr {
    private Document doc;
    public static final String CIRCLE_NM = "circle";

    public SvgCircleBldr(Document doc) {
        this.doc = doc;
    }

    public Element buildElm(Ellipse2D ellipse, Color strokeColor, Color fillColor) {
        Element elm = XmlHelper.createElementSimple(this.doc, CIRCLE_NM, "");
        XmlHelper.setAttr(elm, "cx", (int)ellipse.getCenterX());
        XmlHelper.setAttr(elm, "cy", (int)ellipse.getCenterY());
        XmlHelper.setAttr(elm, "r", (int)(ellipse.getWidth() / 2.0));
        elm.setAttribute("style", this.getStyleValue(strokeColor, fillColor));
        return elm;
    }

    private String getStyleValue(Color strokeColor, Color fillColor) {
        String strokeColorStr = SvgUtil.getStrokeColorStr(strokeColor);
        String fillStr = SvgUtil.getFillStr(fillColor);
        return strokeColorStr + fillStr;
    }
}

