/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.sketch.object.Zone;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZoneXmlCtrl
implements IXmlCtrl {
    public static final String ZONES = "Zones";
    public static final String ZONE = Zone.getClassName();

    public Element asXmlElement(Document doc, List<Zone> zones) {
        Element elmZones = doc.createElement(ZONES);
        for (Zone zone : zones) {
            Element elmZone = XmlHelper.createElementSimple(doc, ZONE, zone.getText());
            Rectangle bounds = zone.getBounds();
            elmZone.setAttribute("nm", zone.getName());
            XmlHelper.addRectAttrs(elmZone, bounds);
            Color bkColor = zone.getColor();
            elmZone.setAttribute("bkCl", Integer.toHexString(bkColor.getRGB()));
            elmZones.appendChild(elmZone);
        }
        return elmZones;
    }

    public static List<Zone> fromXml(Element elmZones) {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        NodeList elms = elmZones.getElementsByTagName(ZONE);
        for (int i = 0; i < elms.getLength(); ++i) {
            Element elm = (Element)elms.item(i);
            String nm = elm.getAttribute("nm");
            String text = XmlHelper.getElementValue(elm);
            Rectangle bounds = XmlHelper.getRectFromAttrs(elm);
            Color color = BasicColorable.fromXmlHexString(elm, "bkCl");
            Zone zone = new Zone(nm, text, bounds);
            zone.setColor(color);
            zones.add(zone);
        }
        return zones;
    }
}

