/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml;

import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.sketch.linkStrategies.right_angle.RightAngleStrategy;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;

public final class LinkStrategyXmlParser {
    public LinkStrategy parseLinkStrategy(String strategyName) {
        LinkStrategy strategy = new OffsetDirect();
        if (Validator.isStringValid(strategyName)) {
            if (strategyName.equals("KeyToKeyStrategy")) {
                Database db = LookupUtil.findDb();
                strategy = new KeyToKeyStrategy(db);
            } else if (strategyName.equals("RightAngleStrategy")) {
                Database db = LookupUtil.findDb();
                strategy = new RightAngleStrategy();
            }
        } else {
            LogUtil.logErr("LinkStrategyXmlParser.err: Strategy name is invalid: " + strategyName);
        }
        return strategy;
    }
}

