/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml;

import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotationFactory;
import com.harrand.dbwrench.diagram.table.fill.RectangleFillFactory;
import com.harrand.sketch.glyph.rect.fill.HeaderFooterFill;
import com.harrand.sketch.glyph.rect.fill.IRectangleFill;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.util.MathUtil;
import com.harrand.util.XmlHelper;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DiagramProps {
    private boolean showAllColumns_ = true;
    private boolean showFkColumns_ = true;
    private boolean showPkColumns_ = true;
    private boolean showFkNames = true;
    private DbwErNotationFactory erNotationFactory = DbwErNotationFactory.getInstance();
    private RectangleFillFactory rectangleFillFactory = RectangleFillFactory.getInstance();
    private IErNotation erNotation = this.erNotationFactory.getDefaultNotation();
    private IRectangleFill dbTableRectangleFill = new HeaderFooterFill();
    private File svgFile = null;
    public static final String DIA_PROPS = "DiaProps";
    public static final String SHOW = "Show";
    public static final String ALL_COLS = "AllCols";
    public static final String PK_COLS = "PkCols";
    public static final String FK_COLS = "FkCols";
    public static final String FK_NAMES = "FkNms";
    public static final String PATH_NM = "path";
    public static final String SVG_NM = "svg";

    public Element asXmlElement(Document doc) {
        Element elmDiaProps = doc.createElement(DIA_PROPS);
        Element elmShow = doc.createElement(SHOW);
        XmlHelper.setAttrBoolAsInt(elmShow, ALL_COLS, this.showAllColumns_);
        XmlHelper.setAttrBoolAsInt(elmShow, PK_COLS, this.showPkColumns_);
        XmlHelper.setAttrBoolAsInt(elmShow, FK_COLS, this.showFkColumns_);
        XmlHelper.setAttrBoolAsInt(elmShow, FK_NAMES, this.showFkNames);
        elmDiaProps.appendChild(elmShow);
        Element elmErNotation = this.getErNotation().asXmlElement();
        XmlHelper.addForeignElement(doc, elmDiaProps, elmErNotation);
        Element elmRectangleFill = this.getDbTableRectangleFill().asXmlElement();
        XmlHelper.addForeignElement(doc, elmDiaProps, elmRectangleFill);
        elmDiaProps.appendChild(this.getSvgFileElm(doc));
        return elmDiaProps;
    }

    private Element getSvgFileElm(Document doc) {
        Element elm = XmlHelper.createElementSimple(doc, SVG_NM, "");
        String pathStr = this.svgFile != null ? this.svgFile.getPath() : "";
        elm.setAttribute(PATH_NM, pathStr);
        return elm;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiagramProps)) {
            return false;
        }
        DiagramProps other = (DiagramProps)o;
        if (this.getShowAllColumns() != other.getShowAllColumns()) {
            return false;
        }
        if (this.getShowPkColumns() != other.getShowPkColumns()) {
            return false;
        }
        if (this.getShowFkColumns() != other.getShowFkColumns()) {
            return false;
        }
        if (this.getShowFkNames() != other.getShowFkNames()) {
            return false;
        }
        if (MathUtil.compareNulls2(this.getSvgFile(), other.getSvgFile()) != 0) {
            return false;
        }
        if (this.erNotation.equals(other.getErNotation())) {
            return false;
        }
        return !this.dbTableRectangleFill.equals(other.getDbTableRectangleFill());
    }

    private boolean isSame(boolean thisItem, boolean otherItem) {
        return thisItem == otherItem;
    }

    public void fromXml(Element elmDiaProps) {
        if (elmDiaProps != null) {
            Element elmShow = XmlHelper.getFirstElementByTagName(elmDiaProps, SHOW);
            this.setShowAllColumns(XmlHelper.getAttrBoolFromInt(elmShow, ALL_COLS));
            this.setShowPkColumns(XmlHelper.getAttrBoolFromInt(elmShow, PK_COLS));
            this.setShowFkColumns(XmlHelper.getAttrBoolFromInt(elmShow, FK_COLS));
            this.setShowFkNames(XmlHelper.getAttrBoolFromInt(elmShow, FK_NAMES));
            this.getErNotationFromXm(elmDiaProps);
            this.getRectangleFillFromXml(elmDiaProps);
            this.getSvgPathFromXml(elmDiaProps);
        }
    }

    private void getErNotationFromXm(Element elmParent) {
        Element erElm = XmlHelper.getFirstElementByTagName(elmParent, "ErNotation");
        if (erElm != null) {
            String notationNm = XmlHelper.getElementValue(erElm);
            this.setErNotation(this.erNotationFactory.getNotation(notationNm));
        }
    }

    private void getRectangleFillFromXml(Element elmDiaProps) {
        Element fillElm = XmlHelper.getFirstElementByTagName(elmDiaProps, "DbTableRectangleFill");
        if (fillElm != null) {
            String name = XmlHelper.getElementValue(fillElm);
            this.setDbTableRectangleFill(this.rectangleFillFactory.getRectangleFill(name));
        }
    }

    public void getSvgPathFromXml(Element elmDiaProps) {
        Element svgElm = XmlHelper.getFirstElementByTagName(elmDiaProps, SVG_NM);
        if (svgElm != null) {
            String path = svgElm.getAttribute(PATH_NM);
            File file = path.length() > 0 ? new File(path) : null;
            this.setSvgFile(file);
        }
    }

    public void setShowAllColumns(boolean showAllColumns) {
        this.showAllColumns_ = showAllColumns;
    }

    public void setShowFkColumns(boolean showFkColumns) {
        this.showFkColumns_ = showFkColumns;
    }

    public void setShowPkColumns(boolean showPkColumns) {
        this.showPkColumns_ = showPkColumns;
    }

    public File getSvgFile() {
        return this.svgFile;
    }

    public void setSvgFile(File svgFile) {
        this.svgFile = svgFile;
    }

    public boolean getShowFkNames() {
        return this.showFkNames;
    }

    public void setShowFkNames(boolean showFkNames) {
        this.showFkNames = showFkNames;
    }

    public void setErNotation(IErNotation erNotation) {
        this.erNotation = erNotation;
    }

    public boolean getShowAllColumns() {
        return this.showAllColumns_;
    }

    public boolean getShowFkColumns() {
        return this.showFkColumns_;
    }

    public boolean getShowPkColumns() {
        return this.showPkColumns_;
    }

    public IErNotation getErNotation() {
        return this.erNotation;
    }

    public IRectangleFill getDbTableRectangleFill() {
        return this.dbTableRectangleFill;
    }

    public void setDbTableRectangleFill(IRectangleFill dbTableRectangleFill) {
        this.dbTableRectangleFill = dbTableRectangleFill;
    }
}

