/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.support.clipboard;

import com.harrand.coreclasses.element.IDiagramCopyable;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchgui.diagram.layout.LayoutGlyphsDisp;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.interfaces.IAutoAddedGlyph;
import com.harrand.sketch.support.clipboard.GlyphClipboard;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

public class PasteGlyphs
extends Command {
    private final GlyphClipboard clipboard_ = GlyphClipboard.getInstance();
    private Diagram destinationDiagram_ = null;
    private List<Glyph> cbGlyphs_ = new ArrayList<Glyph>();
    private List<Glyph> glyphCopies_ = null;
    private Rectangle vpRect_ = null;
    private final String name_ = "Paste Glyphs";
    private Point pastePt_ = null;
    private static final Point DEFAULT_PASTE_PT = new Point(50, 50);
    private static final int VP_MARGIN = 15;

    public PasteGlyphs() {
        this.pastePt_ = DEFAULT_PASTE_PT;
        this.init();
    }

    public PasteGlyphs(Point pastePt) {
        this.pastePt_ = pastePt;
        this.init();
    }

    private PasteGlyphs(Diagram destination, List<Glyph> glyphCopies, Point pastePt) {
        this.destinationDiagram_ = destination;
        this.glyphCopies_ = glyphCopies;
        this.pastePt_ = pastePt;
        this.setCmdChain();
    }

    @Override
    protected void execute() {
        this.cbGlyphs_ = this.clipboard_.getGlyphs();
        if (this.cbGlyphs_ != null) {
            for (Glyph glyph : this.cbGlyphs_) {
                if (!(glyph instanceof DbTableGlyph)) continue;
                DbTableGlyph dbTableGlyph = (DbTableGlyph)glyph;
                Database clipboardDb = dbTableGlyph.getTable().getSchema().getDb();
                Database currentDb = LookupUtil.findDb();
                if (clipboardDb.getName().equals(currentDb.getName())) continue;
                GuiMessageHelper.showInputErrMsg(null, "Glyph Paste", "Glyphs can not be copied between database designs.");
                return;
            }
        }
        this.clipboard_.loadCurrentDiagram();
        this.destinationDiagram_ = this.clipboard_.getDiagram();
        this.checkPastePoint();
        this.createGlyphCopies();
        this.destinationDiagram_.initAddGlyphs(this.glyphCopies_);
        this.destinationDiagram_.setSelectedGlyphs2(this.glyphCopies_);
        LayoutGlyphsDisp layoutGlyphsDisp = new LayoutGlyphsDisp();
        layoutGlyphsDisp.layoutGlyphs(this.destinationDiagram_, this.glyphCopies_, this.pastePt_);
    }

    @Override
    protected void undo() {
        this.destinationDiagram_.removeGlyphs2(this.glyphCopies_);
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + "Paste Glyphs";
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", 89);
        this.putValue("AcceleratorKey", this.getAcceleratorStroke());
    }

    private Object getAcceleratorStroke() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(86, 3);
        KeyStroke macKeyStroke = KeyStroke.getKeyStroke(86, 5);
        if (OsUtil.isMacOs()) {
            return macKeyStroke;
        }
        return keyStroke;
    }

    @Override
    public Command duplicate() {
        PasteGlyphs cmdNew = new PasteGlyphs(this.destinationDiagram_, this.glyphCopies_, this.pastePt_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    private void createGlyphCopies() {
        this.storePasteDiagramVpRect();
        this.glyphCopies_ = new ArrayList<Glyph>();
        for (Glyph oldGlyph : this.cbGlyphs_) {
            if (!(oldGlyph instanceof IDiagramCopyable)) continue;
            IDiagramCopyable copyable = (IDiagramCopyable)((Object)oldGlyph);
            Glyph newGlyph = (Glyph)((Object)copyable.copy(this.destinationDiagram_));
            this.translate(oldGlyph, newGlyph);
            if (newGlyph instanceof IAutoAddedGlyph) continue;
            this.glyphCopies_.add(newGlyph);
        }
    }

    private Point getPasteOrigin() {
        if (this.pastePt_ != null) {
            return this.pastePt_;
        }
        return new Point(this.vpRect_.x + 15, this.vpRect_.y + 15);
    }

    private void init() {
        this.setCmdChain();
        this.setProps();
    }

    private void translate(Glyph oldGlyph, Glyph newGlyph) {
        Point pasteOrigin = this.getPasteOrigin();
        int originX = pasteOrigin.x;
        int originY = pasteOrigin.y;
        Point relPt = this.clipboard_.getRelativePosition(oldGlyph);
        Point newPt = new Point(originX + relPt.x, originY + relPt.y);
        newGlyph.move(newPt);
    }

    private void storePasteDiagramVpRect() {
        this.vpRect_ = this.destinationDiagram_.getViewportRect();
        if (this.vpRect_ == null) {
            this.vpRect_ = new Rectangle();
        }
    }

    private void setCmdChain() {
        this.setCommandChain(CommandChainMgr.getCmdChain());
    }

    private void checkPastePoint() {
        Point lastMousePt;
        if (this.pastePt_ == DEFAULT_PASTE_PT && (lastMousePt = this.destinationDiagram_.getLastMousePt()) != null) {
            this.pastePt_ = lastMousePt;
        }
    }
}

