/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.support.clipboard;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.nb.IWindowUtil;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.IDiagramSrv;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GlyphClipboard {
    private static GlyphClipboard instance__ = new GlyphClipboard();
    private Point srcOrigin_ = null;
    private Diagram diagram_ = null;
    private List<Glyph> glyphs_ = new ArrayList<Glyph>();
    private Map<String, Point> originalPositions_ = new TreeMap<String, Point>();
    private Map<String, Point> relativePositions_ = new TreeMap<String, Point>();
    private IWindowUtil windowUtil_ = null;

    private GlyphClipboard() {
    }

    public static GlyphClipboard getInstance() {
        return instance__;
    }

    public void setWindowUtil(IWindowUtil windowUtil) {
        this.windowUtil_ = windowUtil;
    }

    public List<Glyph> getGlyphs() {
        return this.glyphs_;
    }

    public Point getRelativePosition(Glyph glyph) {
        return this.relativePositions_.get(glyph.getName());
    }

    public int getGlyphCount() {
        return this.getGlyphs().size();
    }

    public void storeSelectedGlyphs() {
        this.clear();
        this.loadCurrentDiagram();
        if (this.diagram_ == null) {
            return;
        }
        List selectedGlyphs = this.diagram_.getSelectedGlyphs(false);
        this.setSrcOrigin(selectedGlyphs);
        this.storePositions(selectedGlyphs);
    }

    public Diagram getDiagram() {
        return this.diagram_;
    }

    public void clear() {
        this.glyphs_.clear();
        this.originalPositions_.clear();
        this.relativePositions_.clear();
    }

    private void storePositions(List selectedGlyphs) {
        for (Glyph glyph : selectedGlyphs) {
            Rectangle2D bounds = glyph.getBounds2D();
            Point originalPt = new Point((int)bounds.getX(), (int)bounds.getY());
            int relX = originalPt.x - this.srcOrigin_.x;
            int relY = originalPt.y - this.srcOrigin_.y;
            Point relPt = new Point(relX, relY);
            this.glyphs_.add(glyph);
            this.relativePositions_.put(glyph.getName(), relPt);
            this.originalPositions_.put(glyph.getName(), originalPt);
        }
    }

    public void loadCurrentDiagram() {
        String diagramNm = this.windowUtil_.getVisibleDiagramTC_Nm();
        if (diagramNm != null) {
            IDiagramSrv diagramSrv = this.getDiagramSrv();
            this.diagram_ = diagramSrv.getDiagram(diagramNm);
        } else {
            this.diagram_ = null;
            GuiMessageHelper.showWarningMsg(null, "No Diagram Showing", "A diagram must be showing from which to cut or copy glyphs.");
        }
    }

    private IDiagramSrv getDiagramSrv() {
        IDiagramSrv srv = (IDiagramSrv)CentralLookup.getDefault().lookup(IDiagramSrv.class);
        return srv;
    }

    private void setSrcOrigin(List selectedGlyphs) {
        int minX = (int)this.diagram_.getBounds2D().getMaxX();
        int minY = (int)this.diagram_.getBounds2D().getMaxY();
        for (Glyph glyph : selectedGlyphs) {
            Rectangle2D glyphBounds = glyph.getBounds2D();
            minX = Math.min(minX, (int)glyphBounds.getMinX());
            minY = Math.min(minY, (int)glyphBounds.getMinY());
        }
        this.srcOrigin_ = new Point(minX, minY);
    }
}

