/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.support.clipboard;

import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.support.clipboard.GlyphClipboard;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

public class CutGlyphs
extends Command {
    private final GlyphClipboard clipboard_ = GlyphClipboard.getInstance();
    private Diagram srcDiagram_ = null;
    private List<Glyph> selectedGlyphs_ = new ArrayList<Glyph>();
    private final String name_ = "Cut Glyphs";

    public CutGlyphs() {
        this.setProps();
        this.setCmdChain();
    }

    private CutGlyphs(Diagram srcDiagram, List<Glyph> selectedGlyphs) {
        this.srcDiagram_ = srcDiagram;
        this.selectedGlyphs_ = selectedGlyphs;
        this.setCmdChain();
    }

    @Override
    protected void execute() {
        this.clipboard_.storeSelectedGlyphs();
        this.selectedGlyphs_ = this.clipboard_.getGlyphs();
        this.srcDiagram_ = this.clipboard_.getDiagram();
        this.srcDiagram_.removeGlyphs2(this.selectedGlyphs_);
    }

    @Override
    protected void undo() {
        this.srcDiagram_.initAddGlyphs(this.selectedGlyphs_);
        this.clipboard_.clear();
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + "Cut Glyphs";
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", new Integer(85));
        this.putValue("AcceleratorKey", this.getAcceleratorStroke());
    }

    @Override
    public Command duplicate() {
        CutGlyphs cmdNew = new CutGlyphs(this.srcDiagram_, this.selectedGlyphs_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    private Object getAcceleratorStroke() {
        KeyStroke windosKeyStroke = KeyStroke.getKeyStroke(88, 3);
        KeyStroke macKeyStroke = KeyStroke.getKeyStroke(88, 5);
        if (OsUtil.isMacOs()) {
            return macKeyStroke;
        }
        return windosKeyStroke;
    }

    private void setCmdChain() {
        this.setCommandChain(CommandChainMgr.getCmdChain());
    }
}

