/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.support;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.util.LogUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.util.List;

public class DrawableUtil {
    public static void drawPreImaged(IPreImagedGlyph preGlyph, Graphics2D g2, Zoom zoom) {
        Rectangle2D bounds = DrawableUtil.getBounds(preGlyph);
        int x = (int)bounds.getX();
        int y = (int)bounds.getY();
        if (zoom.isOne()) {
            g2.drawImage((Image)preGlyph.getImage(), x, y, null);
        } else {
            double zoomLevel = zoom.getLevel();
            AffineTransform tx = new AffineTransform();
            tx.scale(zoomLevel, zoomLevel);
            AffineTransformOp txOp = new AffineTransformOp(tx, 3);
            g2.drawImage(preGlyph.getImage(), txOp, (int)((double)x * zoomLevel), (int)((double)y * zoomLevel));
        }
    }

    public static void drawMixedItems(List mixedItems, Graphics2D g2, Zoom zoom) {
        for (Object obj : mixedItems) {
            if (obj instanceof IDrawable) {
                ((IDrawable)obj).draw(g2, zoom);
                continue;
            }
            if (obj instanceof Shape) {
                g2.draw((Shape)obj);
                continue;
            }
            LogUtil.logErr("DrawableUtil.err: Unrecognized Item. Could not draw: " + obj.getClass().getSimpleName());
        }
    }

    private static Rectangle2D getBounds(IPreImagedGlyph preGlyph) {
        Rectangle2D bounds = preGlyph instanceof Glyph ? ((Glyph)((Object)preGlyph)).getBounds2D() : ((ISized)((Object)preGlyph)).getPreferredBounds();
        return bounds;
    }
}

