/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.primitive;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import java.awt.geom.Point2D;

public class JointPrimitiveCalc
implements IObserver {
    private JointDimensionCalc jointDimCalc;
    private Point2D start;
    private Point2D endPt;
    private Point2D lateStartPt;
    private double angle;
    private int triangleBase;
    private double radians;

    public JointPrimitiveCalc(Point2D start, double angle, JointDimensionCalc jointDimCalc) {
        this.jointDimCalc = jointDimCalc;
        this.start = start;
        this.angle = angle;
        jointDimCalc.addObserver(this);
        this.doCalcs();
    }

    public void setAngle(double angle) {
        this.angle = angle;
        this.doCalcs();
    }

    public void setStart(Point2D start) {
        this.start = start;
        this.doCalcs();
    }

    private void doCalcs() {
        this.radians = Math.toRadians(this.angle);
        this.triangleBase = this.calcTriangleBase();
        this.calcLateStartPt();
        this.calcEndPoint();
    }

    private int calcTriangleBase() {
        double baseD = 2 * this.jointDimCalc.getCircleRadius();
        int wholePart = (int)baseD;
        int remainder = wholePart % 2;
        int base = remainder == 0 ? wholePart + 1 : wholePart;
        return base;
    }

    public double getAngle() {
        return this.angle;
    }

    public Point2D getStart() {
        return this.start;
    }

    public double getBackBoneLength() {
        return this.jointDimCalc.getBackBoneLength();
    }

    public int getCircleRadius() {
        return this.jointDimCalc.getCircleRadius();
    }

    public int getDiameter() {
        return this.jointDimCalc.getDiameter();
    }

    public double getOffset() {
        return this.jointDimCalc.getOffset();
    }

    public int getTriangleBase() {
        return this.triangleBase;
    }

    public Point2D getEndPt() {
        return this.endPt;
    }

    public Point2D getLateStartPt() {
        return this.lateStartPt;
    }

    private void calcEndPoint() {
        double endX = this.start.getX() + Math.cos(this.radians) * this.getBackBoneLength();
        double endY = this.start.getY() - Math.sin(this.radians) * this.getBackBoneLength();
        this.endPt = new Point2D.Double(endX, endY);
    }

    private void calcLateStartPt() {
        double endX = this.start.getX() + Math.cos(this.radians) * (double)this.getDiameter();
        double endY = this.start.getY() - Math.sin(this.radians) * (double)this.getDiameter();
        this.lateStartPt = new Point2D.Double(endX, endY);
    }

    public double getLength() {
        return this.getBackBoneLength();
    }

    public double getHeight() {
        return this.getDiameter();
    }

    @Override
    public void update(UpdateChain chain) {
        this.doCalcs();
    }
}

