/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.primitive;

import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.relation.primitive.JointPrimitiveCalc;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JointPrimitiveBldr {
    private final JointPrimitiveCalc primitiveCalc;
    private Color strokeColor = Color.BLACK;
    private Color fillColor = Color.BLACK;
    private Map<ShapeType, EnhancedShape> eshapes = new HashMap<ShapeType, EnhancedShape>();

    public JointPrimitiveBldr(JointPrimitiveCalc primitiveCalc, Color strokeColor) {
        this.setStrokeColor(strokeColor);
        this.primitiveCalc = primitiveCalc;
    }

    public final void setStrokeColor(Color color) {
        this.strokeColor = color;
        this.fillColor = color;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public EnhancedShape getOneLine() {
        Point2D ptA = this.createRotatedPt(this.getOffset(), this.getCircleRadius());
        Point2D ptB = this.createRotatedPt(this.getOffset(), -this.getCircleRadius());
        ptA = this.addPts(ptA);
        ptB = this.addPts(ptB);
        return this.asEnhanced(new Line2D.Double(ptA, ptB), ShapeType.ONE_LINE);
    }

    public EnhancedShape getOnlyOneLine() {
        double x = this.getCircleRadius() + 1.0;
        Point2D ptA = this.createRotatedPt(x, this.getCircleRadius());
        Point2D ptB = this.createRotatedPt(x, -this.getCircleRadius());
        ptA = this.addPts(ptA);
        ptB = this.addPts(ptB);
        return this.asEnhanced(new Line2D.Double(ptA, ptB), ShapeType.ONLY_ONE_LINE);
    }

    public EnhancedShape getCircleAtBase(boolean isFilled) {
        Point2D center = this.createRotatedPt(this.getCircleRadius(), 0.0);
        center = this.addPts(center);
        Ellipse2D circle = GeometryHelper.getEllipse(center, 2.0 * this.getCircleRadius(), 2.0 * this.getCircleRadius());
        EnhancedShape enhanced = this.asEnhanced(circle, isFilled, ShapeType.CIRCLE_AT_BASE);
        return enhanced;
    }

    public EnhancedShape getCircleElevated() {
        Point2D center = this.createRotatedPt(this.getOffset() + 1.0 + this.getCircleRadius(), 0.0);
        center = this.addPts(center);
        Ellipse2D circle = GeometryHelper.getEllipse(center, 2.0 * this.getCircleRadius(), 2.0 * this.getCircleRadius());
        return this.asEnhanced(circle, ShapeType.CIRCLE_ELEVATED);
    }

    public EnhancedShape getBackbone(boolean isDashed) {
        Line2D.Double backBone = new Line2D.Double(this.getStartPt(), this.getEndPoint());
        EnhancedShape enhanced = this.asEnhanced(backBone, ShapeType.BACKBONE);
        enhanced.setIsDashed(isDashed);
        return enhanced;
    }

    public EnhancedShape getBackboneShortenedBarker(boolean isDashed) {
        Line2D.Double shortBackBone = new Line2D.Double(this.getStartPt(), this.getLateStartPt());
        EnhancedShape enhanced = this.asEnhanced(shortBackBone, ShapeType.BACKBONE_SHORTENED);
        enhanced.setIsDashed(isDashed);
        return enhanced;
    }

    public EnhancedShape getBackboneShortenedDbw() {
        Line2D.Double shortBackBone = new Line2D.Double(this.getStartPt(), this.getLateStartPt());
        EnhancedShape enhanced = this.asEnhanced(shortBackBone, ShapeType.BACKBONE_SHORTENED);
        return enhanced;
    }

    public EnhancedShape getBackboneShortenedBachman() {
        Line2D.Double shortBackBone = new Line2D.Double(this.getLateStartPt(), this.getEndPoint());
        EnhancedShape enhanced = this.asEnhanced(shortBackBone, ShapeType.BACKBONE_SHORTENED);
        return enhanced;
    }

    public List<EnhancedShape> getCrowFootShapes(boolean isDashed) {
        Point2D ptCommon = this.createRotatedPt(this.getOffset(), 0.0);
        Point2D ptLeft = this.createRotatedPt(0.0, this.getCircleRadius());
        Point2D ptMiddle = this.createRotatedPt(0.0, 0.0);
        Point2D ptRight = this.createRotatedPt(0.0, -this.getCircleRadius());
        ptCommon = this.addPts(ptCommon);
        ptLeft = this.addPts(ptLeft);
        ptMiddle = this.addPts(ptMiddle);
        ptRight = this.addPts(ptRight);
        ArrayList<EnhancedShape> shapes = new ArrayList<EnhancedShape>();
        Line2D.Double leftLine = new Line2D.Double(ptCommon, ptLeft);
        Line2D.Double rightLine = new Line2D.Double(ptCommon, ptRight);
        shapes.add(this.asEnhanced(leftLine, ShapeType.CROWFOOT_LEFT));
        shapes.add(this.asEnhanced(rightLine, ShapeType.CROWFOOT_RIGHT));
        Line2D.Double middleLine = new Line2D.Double(ptCommon, ptMiddle);
        EnhancedShape middleShape = this.asEnhanced(middleLine, ShapeType.CROWFOOT_MIDDLE);
        middleShape.setIsDashed(isDashed);
        shapes.add(middleShape);
        return shapes;
    }

    private Point2D createRotatedPt(double x, double y) {
        return GeometryHelper.rotatePointJ2D(new Point2D.Double(x, y), this.getAngle());
    }

    private Point2D addPts(Point2D ptCommon) {
        return GeometryHelper.add(ptCommon, this.getStartPt());
    }

    public EnhancedShape getTriangle() {
        double base = this.getTriangleBase();
        double height = 3.0 * this.getCircleRadius();
        double triangleStartX = 2.0 * this.getCircleRadius();
        double triangleBaseX = triangleStartX + height;
        double y = (int)(0.5 * base) + 1;
        Point2D pCircle = this.createRotatedPt(triangleStartX, 0.0);
        Point2D pTop = this.createRotatedPt(triangleBaseX, -y);
        Point2D pBottom = this.createRotatedPt(triangleBaseX, y);
        pCircle = this.addPts(pCircle);
        pTop = this.addPts(pTop);
        pBottom = this.addPts(pBottom);
        int[] xPoints = new int[]{(int)pCircle.getX(), (int)pTop.getX(), (int)pBottom.getX()};
        int[] yPoints = new int[]{(int)pCircle.getY(), (int)pTop.getY(), (int)pBottom.getY()};
        Polygon triangle = new Polygon(xPoints, yPoints, xPoints.length);
        EnhancedShape enhanced = this.asEnhanced(triangle, true, ShapeType.TRIANGLE);
        return enhanced;
    }

    private EnhancedShape asEnhanced(Shape shape, ShapeType shapeType) {
        return this.asEnhanced(shape, false, shapeType);
    }

    private EnhancedShape asEnhanced(Shape shape, boolean isFilled, ShapeType shapeType) {
        EnhancedShape eShape = null;
        if (this.eshapes.containsKey((Object)shapeType)) {
            eShape = this.eshapes.get((Object)shapeType);
            eShape.setShape(shape);
        } else {
            eShape = new EnhancedShape(shape);
            this.eshapes.put(shapeType, eShape);
        }
        eShape.setStrokeColor(this.strokeColor);
        eShape.setIsFilled(isFilled);
        if (isFilled) {
            eShape.setFillColor(this.fillColor);
        }
        return eShape;
    }

    private double getOffset() {
        return this.primitiveCalc.getOffset();
    }

    private double getCircleRadius() {
        return this.primitiveCalc.getCircleRadius();
    }

    private double getTriangleBase() {
        return this.primitiveCalc.getTriangleBase();
    }

    private Point2D getEndPoint() {
        return this.primitiveCalc.getEndPt();
    }

    private Point2D getLateStartPt() {
        return this.primitiveCalc.getLateStartPt();
    }

    private double getAngle() {
        return this.primitiveCalc.getAngle();
    }

    private Point2D getStartPt() {
        return this.primitiveCalc.getStart();
    }

    public static enum ShapeType {
        ONE_LINE,
        ONLY_ONE_LINE,
        CIRCLE_AT_BASE,
        TRIANGLE,
        CIRCLE_ELEVATED,
        BACKBONE,
        BACKBONE_SHORTENED,
        CROWFOOT_LEFT,
        CROWFOOT_MIDDLE,
        CROWFOOT_RIGHT;

    }
}

