/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.line;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.relation.line.LineAnchorRectFinder;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class PositionableLine
extends Line2D.Double {
    private final Coord xPosition = new Coord();
    private final Coord yPosition = new Coord();
    private LineRole lineRole = LineRole.SINGLE_LINE;

    public PositionableLine(Point2D startPt, Point2D endPoint, LinkRect anchorRect, LineRole lineRoleIn) {
        super(startPt, endPoint);
        if (lineRoleIn != null) {
            this.setLineRole(lineRoleIn);
        }
        this.updateAbs(anchorRect);
    }

    public void setLineRole(LineRole lineRole) {
        this.lineRole = lineRole;
    }

    public int getLength() {
        return (int)this.getP1().distance(this.getP2());
    }

    public boolean isZeroLength() {
        return this.getLength() == 0;
    }

    public Rectangle2D getAnchorRect(BoxLink boxLink) {
        return this.getRects(boxLink)[0];
    }

    public void setAbsX(BoxLink boxLink, double newX) {
        this.setAbsX(this.getAnchorRect(boxLink), newX);
    }

    public void setAbsY(BoxLink boxLink, double newY) {
        this.setAbsY(this.getAnchorRect(boxLink), newY);
    }

    public void setAbsX(Rectangle2D anchorRect, double newX) {
        this.xPosition.setAbsCoord(newX, anchorRect.getMinX());
    }

    public void setAbsY(Rectangle2D anchorRect, double newY) {
        this.yPosition.setAbsCoord(newY, anchorRect.getMinY());
    }

    public void updateAbs(BoxLink boxLink) {
        if (this.isVerticalLine()) {
            this.setAbsX(this.getAnchorRect(boxLink), this.x1);
        } else {
            this.setAbsY(this.getAnchorRect(boxLink), this.y1);
        }
    }

    private void updateAbs(LinkRect anchorRect) {
        if (this.isVerticalLine()) {
            this.setAbsX(anchorRect, this.x1);
        } else {
            this.setAbsY(anchorRect, this.y1);
        }
    }

    @Override
    public void setLine(Point2D p1, Point2D p2) {
        super.setLine(p1, p2);
    }

    public LinkRect[] getRects(BoxLink boxLink) {
        LineAnchorRectFinder rectFinder = new LineAnchorRectFinder();
        return rectFinder.getRects(boxLink, this.getLineRole());
    }

    public boolean isBoxEdgeLimited() {
        return LineRole.CHILD_LINE.equals((Object)this.lineRole) || LineRole.PARENT_LINE.equals((Object)this.lineRole) || LineRole.SINGLE_LINE.equals((Object)this.lineRole);
    }

    public LineRole getLineRole() {
        return this.lineRole;
    }

    public boolean isMiddleLine() {
        return LineRole.MIDDLE_LINE.equals((Object)this.getLineRole());
    }

    public boolean isParentLine() {
        return LineRole.PARENT_LINE.equals((Object)this.getLineRole());
    }

    public boolean isChildLine() {
        return LineRole.CHILD_LINE.equals((Object)this.getLineRole());
    }

    public Double getRelX() {
        return this.xPosition.getRelCoord();
    }

    public Double getRelY() {
        return this.yPosition.getRelCoord();
    }

    public void updatePosition(Link link) {
        if (this.isVerticalLine()) {
            this.updateAbsX(link);
        } else {
            this.updateAbsY(link);
        }
    }

    private void updateAbsX(Link link) {
        double absX = this.getAnchorRect(link).getMinX() + this.getRelX();
        this.setLine(absX, this.y1, absX, this.y2);
    }

    private void updateAbsY(Link link) {
        double absY = this.getAnchorRect(link).getMinY() + this.getRelY();
        this.setLine(this.x1, absY, this.x2, absY);
    }

    public boolean isHorizontalLine() {
        return GeometryHelper.isLineHorizontal(this);
    }

    public boolean isVerticalLine() {
        return GeometryHelper.isLineVertical(this);
    }

    public String toString() {
        return "PosLine - " + (Object)((Object)this.getLineRole()) + "  ( " + this.getP1().getX() + ", " + this.getP1().getY() + ") to (" + this.getP2().getX() + ", " + this.getP2().getY() + "). relX: " + this.getRelX() + ", relY: " + this.getRelY() + ", isVert: " + this.isVerticalLine() + ", isHorz: " + this.isHorizontalLine();
    }

    private final class Coord {
        private Double absCoord = 0.0;
        private Double relCoord = 0.0;

        private Coord() {
        }

        public void setAbsCoord(double absCoord, double relOrigin) {
            this.absCoord = absCoord;
            this.recomputeRelCoord(relOrigin);
        }

        public Double getRelCoord() {
            return this.relCoord;
        }

        private void recomputeRelCoord(double relOrigin) {
            if (this.absCoord != null) {
                this.relCoord = this.absCoord - relOrigin;
            }
        }
    }
}

