/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.line;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public final class LineCloseByCtrl {
    private int allowableDistance;

    public LineCloseByCtrl(int allowableDistance) {
        this.allowableDistance = allowableDistance;
    }

    public Line2D getCloseByLine(Collection<? extends Shape> shapes, Point2D pt) {
        int halfDist = this.allowableDistance / 2;
        boolean isClose = false;
        for (Shape shape : shapes) {
            if (!(shape instanceof Line2D)) continue;
            Line2D line = (Line2D)shape;
            double minx = Math.min(line.getX1(), line.getX2());
            double miny = Math.min(line.getY1(), line.getY2());
            double maxx = Math.max(line.getX1(), line.getX2());
            double maxy = Math.max(line.getY1(), line.getY2());
            double width = maxx - minx + (double)this.allowableDistance;
            double height = maxy - miny + (double)this.allowableDistance;
            Rectangle2D.Double lineRect = new Rectangle2D.Double(minx - (double)halfDist, miny - (double)halfDist, width, height);
            boolean withinRect = lineRect.contains(pt);
            double distance = line.ptLineDist(pt);
            boolean nearLine = distance <= (double)this.allowableDistance;
            isClose = nearLine && withinRect;
            if (!isClose) continue;
            return line;
        }
        return null;
    }
}

