/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.prefs.diagram;

import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.sketch.prefs.diagram.GlyphLocatePrefCtrl;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiagramPrefXmlCtrl
implements IXmlable {
    private GlyphLocatePrefCtrl locatePrefCtrl = GlyphLocatePrefCtrl.getInstance();
    public static final String DIA_PREF_XML_NM = "DiagramPref";
    public static final String SLIDE_LOCATE_XML_NM = "SlideToLocate";

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmPref = doc.createElement(DIA_PREF_XML_NM);
        this.setSlideAttr(elmPref);
        return elmPref;
    }

    public void loadDataFromXml(Element elmParent) {
        if (elmParent != null) {
            this.loadSlideSettings(elmParent);
        }
    }

    private void setSlideAttr(Element elmPref) {
        boolean slideFlag = this.locatePrefCtrl.getSlideToLocateFlag();
        XmlHelper.setAttrBoolAsInt(elmPref, SLIDE_LOCATE_XML_NM, slideFlag);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String newName) {
    }

    private void loadSlideSettings(Element elmParent) {
        Element elmDiaPrefs = XmlHelper.getFirstElementByTagName(elmParent, DIA_PREF_XML_NM);
        if (elmDiaPrefs != null) {
            boolean slideFlag = XmlHelper.getAttrBoolFromInt(elmDiaPrefs, SLIDE_LOCATE_XML_NM);
            this.locatePrefCtrl.setSlideToLocateFlag(slideFlag);
        }
    }
}

