/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.panel.diagram.prefs;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.prefs.diagram.GlyphLocatePrefCtrl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GlyphLocatePrefPanel
extends JPanel {
    private GlyphLocatePrefCtrl ctrl = GlyphLocatePrefCtrl.getInstance();
    private JRadioButton btnSlide = new JRadioButton("Slide to the location of the selected glyph.");
    private JRadioButton btnDirect = new JRadioButton("Move instantly to the location of the selected glyph.");
    private ButtonGroup buttonGroup = new ButtonGroup();
    public static final String TITLE = "Locating Selected Glyph";

    public GlyphLocatePrefPanel() {
        this.init();
    }

    private void init() {
        this.setupGui();
    }

    private void setupGui() {
        this.layoutComponents();
        this.groupButtons();
        this.loadData();
        this.addListeners();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiHelper.getLeftAlignedPanel(this.btnSlide));
        this.add(GuiHelper.getLeftAlignedPanel(this.btnDirect));
        this.add(Box.createVerticalGlue());
    }

    private void setCosmetics() {
        GuiHelper.setTitledBorderBuffered(this, TITLE);
    }

    private void groupButtons() {
        this.buttonGroup.add(this.btnSlide);
        this.buttonGroup.add(this.btnDirect);
    }

    private void loadData() {
        if (this.ctrl.getSlideToLocateFlag()) {
            this.btnSlide.setSelected(true);
        } else {
            this.btnDirect.setSelected(true);
        }
    }

    private void addListeners() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlyphLocatePrefPanel.this.updatePref();
            }
        };
        this.btnDirect.addActionListener(lis);
        this.btnSlide.addActionListener(lis);
    }

    private void updatePref() {
        this.ctrl.setSlideToLocateFlag(this.btnSlide.isSelected());
    }
}

