/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.object;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.display.color.DefaultColorCtrl;
import com.harrand.coreclasses.element.IQualifiedNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import java.awt.Color;
import java.awt.Point;

public class Note
implements Identifiable,
IObservable,
IConfirmRemove,
IQualifiedNm {
    private String text_;
    private Color color_ = DEFAULT_COLOR;
    private BasicObservable observable_ = new BasicObservable();
    private Point origin_;
    private int id_ = nextId__++;
    private static int nextId__ = 0;
    public static final String CLZ = "Note";
    public static final String CLZ_DISPLAY_PL = "Notes";
    public static final Color DEFAULT_COLOR = Colors.getYellowSoft();

    public Note(String text, Point origin) {
        this.setText(text);
        this.setOrigin(origin);
        this.initColor();
    }

    public void setText(String text) {
        this.text_ = text;
        this.notifyObservers(null);
    }

    public void setOrigin(Point origin) {
        this.origin_ = origin;
    }

    public void setColor(Color color) {
        this.color_ = color;
        DefaultColorCtrl.getInstance().putDefaultColor(this.getClass(), this.color_);
        this.notifyObservers(null);
    }

    @Override
    public String getQN() {
        return "Note." + this.getName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Note)) {
            return false;
        }
        Note other = (Note)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getText() == this.getText();
    }

    public Note dup(String newText) {
        Note newNote = new Note(newText, this.getOrigin());
        newNote.setColor(this.getColor());
        return newNote;
    }

    public String toString() {
        return this.getQN() + " - " + this.getShortText();
    }

    public int getNextId() {
        return nextId__;
    }

    public int getId() {
        return this.id_;
    }

    public String getText() {
        return this.text_;
    }

    public Point getOrigin() {
        return this.origin_;
    }

    public Color getColor() {
        return this.color_;
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    @Override
    public String getMapName() {
        return CLZ;
    }

    public static String getClassName() {
        return CLZ;
    }

    @Override
    public String getDisplayClzNm() {
        return CLZ;
    }

    @Override
    public String getDisplayClzPlural() {
        return CLZ_DISPLAY_PL;
    }

    @Override
    public String getName() {
        return Integer.toString(this.id_);
    }

    @Override
    public void setName(String newName) {
    }

    public String getShortText() {
        return StrHelper.getTruncated(this.getText(), 15);
    }

    private void initColor() {
        this.setColor(DefaultColorCtrl.getInstance().getDefaultColorSafe(this.getClass(), DEFAULT_COLOR));
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

