/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.object;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.INotifyMgr;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.NoteGlyph;
import com.harrand.sketch.glyph.ZoneGlyph;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DiagramCollector
implements Collector,
IObservable {
    private BasicCollector basicCollector_ = new BasicCollector("diagramBasicColl");
    private List<NoteGlyph> noteGlyphs_ = new ArrayList<NoteGlyph>();
    private List<ZoneGlyph> zoneGlyphs_ = new ArrayList<ZoneGlyph>();
    private Diagram diagram_;

    public DiagramCollector(Diagram diagram) {
        this.diagram_ = diagram;
        this.basicCollector_ = new BasicCollector("diagramBasicColl." + this.diagram_.getName());
        this.addObserver(this.diagram_);
        this.buildMaps();
    }

    public void setDirtyTracker(IDirtyTracker tracker) {
        this.basicCollector_.setDirtyTracker(tracker);
    }

    public void setNotifyMgr(INotifyMgr mgr) {
        this.basicCollector_.setNotifyMgr(mgr);
    }

    private void buildMaps() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        TreeMap outerMap = new TreeMap();
        outerMap.put(Note.getClassName(), new TreeMap(comparator));
        outerMap.put(Zone.getClassName(), new TreeMap(comparator));
        this.basicCollector_.setOuterMap(outerMap);
    }

    public List<ZoneGlyph> getZoneGlyphs() {
        return this.zoneGlyphs_;
    }

    public List<NoteGlyph> getNoteGlyphs() {
        return this.noteGlyphs_;
    }

    public List<Zone> getZones() {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        for (Zone zone : this.basicCollector_.values(Zone.getClassName())) {
            zones.add(zone);
        }
        return zones;
    }

    public List<Note> getNotes() {
        ArrayList<Note> notes = new ArrayList<Note>();
        Iterator it = this.basicCollector_.values(Note.getClassName()).iterator();
        while (it.hasNext()) {
            notes.add((Note)it.next());
        }
        return notes;
    }

    public Note getNote(String nm) {
        return (Note)this.basicCollector_.get(Note.getClassName(), nm);
    }

    public Zone getZone(String nm) {
        return (Zone)this.basicCollector_.get(Zone.getClassName(), nm);
    }

    public void refreshGlyphs() {
        for (Glyph glyph : this.getAllGlyphs()) {
            if (!(glyph instanceof IRefreshable)) continue;
            ((IRefreshable)((Object)glyph)).refresh();
        }
    }

    public void addGlyph(Glyph glyph) {
        if (glyph instanceof ZoneGlyph) {
            ZoneGlyph zoneGlyph = (ZoneGlyph)glyph;
            this.zoneGlyphs_.add(zoneGlyph);
            this.basicCollector_.add(zoneGlyph.getIdf());
        }
        if (glyph instanceof NoteGlyph) {
            NoteGlyph noteGlyph = (NoteGlyph)glyph;
            this.noteGlyphs_.add(noteGlyph);
            this.basicCollector_.add(noteGlyph.getIdf());
        }
    }

    private void checkCenteringRequired(Glyph glyph) {
        Rectangle vpRect = this.diagram_.getViewportRect();
        if (vpRect != null) {
            Rectangle2D bounds = glyph.getBounds2D();
            int x = (int)bounds.getX();
            int y = (int)bounds.getY();
            if (x == 0 && y == 0) {
                Point vpCenter = this.diagram_.getVpCenterZoomed();
                int newX = vpCenter.x - (int)(0.5 * bounds.getWidth());
                int newY = vpCenter.y - (int)(0.5 * bounds.getHeight());
                Point newOrigin = new Point(newX, newY);
                glyph.move(newOrigin);
            }
        }
    }

    private List<Glyph> getAllGlyphs() {
        ArrayList<Glyph> allGlyphs = new ArrayList<Glyph>();
        allGlyphs.addAll(this.getNoteGlyphs());
        allGlyphs.addAll(this.getZoneGlyphs());
        return allGlyphs;
    }

    public ITestResult checkIdfNameValid(Identifiable idf) {
        return this.basicCollector_.checkIdfNameValid(idf);
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        Map innerMap = this.getInnerMap(mapNm);
        return this.basicCollector_.checkDuplicateNameDisp(innerMap, mapNm, newNm);
    }

    private Map getInnerMap(String mapNm) {
        return this.basicCollector_.getInnerMap(mapNm);
    }

    private ITestResult checkAddAutoGlyph(ITestResult previousRslt, Identifiable idf) {
        if (previousRslt.getPassed() && this.isAutoGlyphType(idf)) {
            IObserver glyph = null;
            if (idf instanceof Note) {
                glyph = new NoteGlyph(this.diagram_, (Note)idf);
                this.noteGlyphs_.add((NoteGlyph)glyph);
            }
            if (idf instanceof Zone) {
                glyph = new ZoneGlyph(this.diagram_, (Zone)idf);
                this.zoneGlyphs_.add((ZoneGlyph)glyph);
            }
            if (glyph != null) {
                this.checkCenteringRequired((Glyph)((Object)glyph));
                this.diagram_.setGlyphsDirtyTracker((Glyph)((Object)glyph));
            }
        }
        return previousRslt;
    }

    private void checkRemoveAutoGlyph(Identifiable idf) {
        String glyphNm = idf.getDisplayClzNm() + "." + idf.getName();
        if (this.isAutoGlyphType(idf)) {
            if (idf instanceof Note) {
                this.removeAutoGlyph(this.noteGlyphs_, glyphNm);
            }
            if (idf instanceof Zone) {
                this.removeAutoGlyph(this.zoneGlyphs_, glyphNm);
            }
        }
    }

    private boolean isAutoGlyphType(Identifiable idf) {
        boolean isType = false;
        if (idf instanceof Note || idf instanceof Zone) {
            isType = true;
        }
        return isType;
    }

    private void removeAutoGlyph(List<? extends Glyph> autoGlyphs, String nm) {
        Glyph removeGlyph = null;
        for (Glyph glyph : autoGlyphs) {
            String glyphNm = glyph.getName();
            if (!glyphNm.equals(nm)) continue;
            removeGlyph = glyph;
        }
        if (removeGlyph != null) {
            autoGlyphs.remove(removeGlyph);
        }
    }

    @Override
    public ITestResult add(Identifiable idf) {
        ITestResult result = this.basicCollector_.add(idf);
        this.checkAddAutoGlyph(result, idf);
        return result;
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        ITestResult result = this.basicCollector_.updateItem(oldIdf, newIdf);
        if (result.getPassed()) {
            this.checkRemoveAutoGlyph(oldIdf);
            this.checkAddAutoGlyph(result, newIdf);
        }
        return result;
    }

    @Override
    public void remove(String mapName, String idfNm) {
        Identifiable idf = this.basicCollector_.get(mapName, idfNm);
        if (idf != null) {
            this.basicCollector_.remove(mapName, idfNm);
            this.checkRemoveAutoGlyph(idf);
        }
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
        this.basicCollector_.rename(idf, oldName, newName);
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        return this.basicCollector_.get(mapName, identifiableName);
    }

    @Override
    public int size(String mapName) {
        return this.basicCollector_.size(mapName);
    }

    @Override
    public List values(String mapName) {
        return this.basicCollector_.values(mapName);
    }

    @Override
    public Set getKeys(String mapName) {
        return this.basicCollector_.getKeys(mapName);
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return this.basicCollector_.contains(mapName, identifiableName);
    }

    @Override
    public String getDisplayName(String mapName) {
        return this.basicCollector_.getDisplayName(mapName);
    }

    @Override
    public String getDisplayPlural(String mapName) {
        return this.basicCollector_.getDisplayPlural(mapName);
    }

    @Override
    public String getMapName() {
        return this.basicCollector_.getMapName();
    }

    @Override
    public String getName() {
        return this.basicCollector_.getName();
    }

    @Override
    public void setName(String newName) {
        this.basicCollector_.setName(newName);
    }

    @Override
    public void addObserver(IObserver observer) {
        this.basicCollector_.addObserver(observer);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.basicCollector_.removeObserver(observer);
    }

    @Override
    public void removeAllObservers() {
        this.basicCollector_.removeAllObservers();
    }

    @Override
    public int getObserverCount() {
        return this.basicCollector_.getObserverCount();
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        this.basicCollector_.notifyObservers(chain);
    }
}

