/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.object;

import com.harrand.sketch.glyph.AnchorGlyph;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class AnchorSelect {
    private Rectangle objRect_ = new Rectangle();
    private List<AnchorGlyph> anchors_ = new ArrayList<AnchorGlyph>();
    public static final String POS_NW = "NW";
    public static final String POS_N = "N";
    public static final String POS_NE = "NE";
    public static final String POS_E = "E";
    public static final String POS_SE = "SE";
    public static final String POS_S = "S";
    public static final String POS_SW = "SW";
    public static final String POS_W = "W";

    public List<AnchorGlyph> getAnchors(Rectangle objRect) {
        this.objRect_ = objRect;
        this.buildAnchors();
        return this.anchors_;
    }

    public Rectangle getResizeRect(AnchorGlyph selectedAnchor, Point dragPt, double zoomLevel) {
        Rectangle zoomedRect = this.objRect_;
        int x1 = zoomedRect.x;
        int y1 = zoomedRect.y;
        int x2 = x1 + zoomedRect.width;
        int y2 = y1 + zoomedRect.height;
        int dragX = (int)dragPt.getX();
        int dragY = (int)dragPt.getY();
        String posStr = selectedAnchor.getPosStr();
        if (posStr.equals(POS_NW)) {
            x1 = dragX;
            y1 = dragY;
        }
        if (posStr.equals(POS_N)) {
            y1 = dragY;
        }
        if (posStr.equals(POS_NE)) {
            x2 = dragX;
            y1 = dragY;
        }
        if (posStr.equals(POS_E)) {
            x2 = dragX;
        }
        if (posStr.equals(POS_SE)) {
            x2 = dragX;
            y2 = dragY;
        }
        if (posStr.equals(POS_S)) {
            y2 = dragY;
        }
        if (posStr.equals(POS_SW)) {
            x1 = dragX;
            y2 = dragY;
        }
        if (posStr.equals(POS_W)) {
            x1 = dragX;
        }
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }

    private void buildAnchors() {
        this.anchors_ = new ArrayList<AnchorGlyph>();
        int x = this.objRect_.x;
        int y = this.objRect_.y;
        int maxY = (int)this.objRect_.getMaxY();
        int maxX = (int)this.objRect_.getMaxX();
        int midX = (int)this.objRect_.getCenterX();
        int midY = (int)this.objRect_.getCenterY();
        this.anchors_.add(this.getAnchor(x, y, POS_NW));
        this.anchors_.add(this.getAnchor(midX, y, POS_N));
        this.anchors_.add(this.getAnchor(maxX, y, POS_NE));
        this.anchors_.add(this.getAnchor(maxX, midY, POS_E));
        this.anchors_.add(this.getAnchor(maxX, maxY, POS_SE));
        this.anchors_.add(this.getAnchor(midX, maxY, POS_S));
        this.anchors_.add(this.getAnchor(x, maxY, POS_SW));
        this.anchors_.add(this.getAnchor(x, midY, POS_W));
    }

    private AnchorGlyph getAnchor(int centerX, int centerY, String posStr) {
        Point pt = new Point(centerX, centerY);
        AnchorGlyph anchorGlyph = new AnchorGlyph(pt, posStr);
        return anchorGlyph;
    }
}

