/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.rollover.switch_edge_ctrl;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.transitioner.ThreeToTwoLineTransitioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.EdgeLimitResult;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.edge.adjacent.EdgeLimitAdjacentEdgeCalc;
import com.harrand.sketch.relation.edge.adjacent.IncursionAdjacentEdgeCalc;
import com.harrand.sketch.relation.rect.LinkRect;

public final class ThreeLineSwitchEdgeCtrl {
    private final IncursionAdjacentEdgeCalc incursionAdjacentEdgeCalc = new IncursionAdjacentEdgeCalc();
    private final EdgeLimitAdjacentEdgeCalc edgeLimitAdjacentEdgeCalc = new EdgeLimitAdjacentEdgeCalc();
    private IEdgeTrackable edgeTrackable;
    private LinkRect transitionedRect;
    private boolean wasAnIncursion;

    public void switchEdge(BoxLink boxLink, LinkRect transitionedRect, LinkRect otherRect, EdgeLimitResult edgeLimitResult, boolean wasAnIncursion) {
        this.transitionedRect = transitionedRect;
        this.edgeTrackable = (IEdgeTrackable)((Object)boxLink);
        this.wasAnIncursion = wasAnIncursion;
        Edge oldEdge = this.getIncurredEdge((IEdgeTrackable)((Object)boxLink));
        Edge newEdge = this.getNewEdge(oldEdge, transitionedRect, otherRect, edgeLimitResult);
        this.setEdge(newEdge);
        this.invokeTransitioner(boxLink, transitionedRect, otherRect, oldEdge, newEdge, wasAnIncursion);
    }

    private void invokeTransitioner(BoxLink boxLink, LinkRect transitionedRect, LinkRect otherRect, Edge oldEdge, Edge newEdge, boolean wasAnIncursion) {
        ThreeToTwoLineTransitioner transitioner = new ThreeToTwoLineTransitioner();
        transitioner.transitionLink(boxLink, transitionedRect, oldEdge, newEdge, wasAnIncursion);
    }

    private Edge getNewEdge(Edge oldEdge, LinkRect transitionedRect, LinkRect otherRect, EdgeLimitResult edgeLimitResult) {
        if (this.wasAnIncursion) {
            return this.incursionAdjacentEdgeCalc.getAdjacentEdge(oldEdge, transitionedRect, otherRect);
        }
        return this.edgeLimitAdjacentEdgeCalc.getAdjacentEdge(oldEdge, edgeLimitResult);
    }

    private Edge getIncurredEdge(IEdgeTrackable edgeTrackable) {
        if (this.transitionedRect.isParent()) {
            return edgeTrackable.getParentEdge();
        }
        if (this.transitionedRect.isChild()) {
            return edgeTrackable.getChildEdge();
        }
        return null;
    }

    private void setEdge(Edge newEdge) {
        if (this.transitionedRect.isParent()) {
            this.edgeTrackable.setParentEdge(newEdge);
        }
        if (this.transitionedRect.isChild()) {
            this.edgeTrackable.setChildEdge(newEdge);
        }
    }
}

