/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.rollover.switch_edge_ctrl;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.rollover.switch_edge_ctrl.OneLineSwitchEdgeCtrl;
import com.harrand.sketch.linkStrategies.rollover.switch_edge_ctrl.ThreeLineSwitchEdgeCtrl;
import com.harrand.sketch.linkStrategies.rollover.switch_edge_ctrl.TwoLineSwitchEdgeCtrl;
import com.harrand.sketch.relation.edge.EdgeLimitResult;
import com.harrand.sketch.relation.rect.LinkRect;
import com.harrand.util.LogUtil;

public final class SwitchEdgeCtrlDispatcher {
    private final LinkLineExtractor lineExtractor = new LinkLineExtractor();
    private final OneLineSwitchEdgeCtrl oneLineSwitchEdgeCtrl = new OneLineSwitchEdgeCtrl();
    private final TwoLineSwitchEdgeCtrl twoLineSwitchEdgeCtrl = new TwoLineSwitchEdgeCtrl();
    private final ThreeLineSwitchEdgeCtrl treeLineSwitchEdgeCtrl = new ThreeLineSwitchEdgeCtrl();

    public void switchEdge(BoxLink boxLink, LinkRect transitionedBox, LinkRect otherBox, EdgeLimitResult edgeLimitResult, boolean wasAnIncursion) {
        int lineCount = this.lineExtractor.getPositionableLines(boxLink).size();
        switch (lineCount) {
            case 1: {
                this.oneLineSwitchEdgeCtrl.switchEdge(boxLink, transitionedBox, edgeLimitResult);
                break;
            }
            case 2: {
                this.twoLineSwitchEdgeCtrl.switchEdge(boxLink, transitionedBox, otherBox, edgeLimitResult, wasAnIncursion);
                break;
            }
            case 3: {
                this.treeLineSwitchEdgeCtrl.switchEdge(boxLink, transitionedBox, otherBox, edgeLimitResult, wasAnIncursion);
                break;
            }
            case 4: {
                LogUtil.logErr("switchEdgeCtrlDispatcher unsupported number of lines: " + lineCount);
            }
        }
    }
}

