/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.transitioner;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.arc.LineBasedArcBuilder;
import com.harrand.sketch.linkStrategies.right_angle.calc.intersect.EdgeTransitionIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.TwoLinePositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineUserLinkPositioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.LineMoveCtrl;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class OneToTwoLineTransitioner {
    private final EdgeTransitionIntersectCalc intersectCalc = new EdgeTransitionIntersectCalc();
    private final TwoLinePositioner twoLinePositioner = new TwoLinePositioner();
    private PositionableLine parentLine;
    private PositionableLine childLine;
    private ArrayList<Shape> shapes;
    private Arc2D arc;

    public void transitionLink(BoxLink boxLink, LinkRect transitionedBox, Edge oldEdge, Edge newEdge) {
        this.positionLines(transitionedBox, oldEdge, newEdge, boxLink);
        this.positionArc();
        this.buildShapes();
        boxLink.setShapes(this.shapes);
        TwoLineUserLinkPositioner twoLineUserLinkPositioner = new TwoLineUserLinkPositioner();
        boxLink.setLinkPositioner(twoLineUserLinkPositioner);
        String transitionedBoxName = transitionedBox.getName();
        PositionableLine moveLine = this.childLine;
        if ("Child".equals(transitionedBoxName)) {
            moveLine = this.parentLine;
        }
        LineMoveCtrl.getInstance().setLine(moveLine, boxLink);
    }

    private void positionLines(Rectangle2D transitionedBox, Edge oldEdge, Edge newEdge, BoxLink boxLink) {
        Point2D intersect = this.intersectCalc.getIntersect(transitionedBox, oldEdge, newEdge);
        this.twoLinePositioner.positionLines(boxLink, intersect);
        this.parentLine = this.twoLinePositioner.getParentLine();
        this.childLine = this.twoLinePositioner.getChildLine();
        this.parentLine.setLineRole(LineRole.PARENT_LINE);
    }

    private void positionArc() {
        this.arc = new LineBasedArcBuilder().getArc(this.childLine, this.parentLine);
    }

    private void buildShapes() {
        this.shapes = new ArrayList();
        this.shapes.add(this.parentLine);
        this.shapes.add(this.childLine);
        if (this.arc != null) {
            this.shapes.add(this.arc);
        }
    }
}

