/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.user;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.arc.LineBasedArcBuilder;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.JointPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.NamePositionCoordSetter;
import com.harrand.sketch.linkStrategies.right_angle.calc.intersect.ThreeLineRelativeIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.ThreeLinePositioner;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.BoxedLineMoveChecker;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public final class ThreeLineUserLinkPositioner
implements ILinkPositioner {
    private final ThreeLineRelativeIntersectCalc intersectCalc = new ThreeLineRelativeIntersectCalc();
    private final ThreeLinePositioner threeLinePositioner = new ThreeLinePositioner();
    private final JointPositioner jointPositioner = new JointPositioner();
    private final NamePositionCoordSetter namePositionCoordSetter = new NamePositionCoordSetter();
    private BoxLink boxLink;
    private PositionableLine childLine;
    private PositionableLine middleLine;
    private PositionableLine parentLine;
    private Arc2D childArc;
    private Arc2D parentArc;
    private final BoxedLineMoveChecker lineMoveChecker = new BoxedLineMoveChecker();
    private boolean isLinkTransitioned;

    @Override
    public void updateShapePositions(BoxLink boxLink) {
        this.boxLink = boxLink;
        this.positionLines();
        if (!this.isLinkTransitioned) {
            this.positionArc();
            this.positionJoints();
            this.updateShapes();
        }
    }

    private void updateShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        shapes.add(this.parentLine);
        shapes.add(this.childLine);
        shapes.add(this.middleLine);
        if (this.parentArc != null) {
            shapes.add(this.parentArc);
        }
        if (this.childArc != null) {
            shapes.add(this.childArc);
        }
        this.boxLink.setShapes(shapes);
        this.namePositionCoordSetter.setNmPos(this.boxLink, this.middleLine);
    }

    private void positionLines() {
        Point2D[] parentAndChildIntersects = this.intersectCalc.calcParentAndChildIntersects(this.boxLink);
        this.threeLinePositioner.positionLines(this.boxLink, parentAndChildIntersects);
        this.parentLine = this.threeLinePositioner.getParentLine();
        this.childLine = this.threeLinePositioner.getChildLine();
        this.middleLine = this.threeLinePositioner.getMiddleLine();
        this.isLinkTransitioned = this.lineMoveChecker.isLinkTransitioned(this.boxLink, this.middleLine, this.parentLine.getP1());
        if (!this.isLinkTransitioned) {
            this.isLinkTransitioned = this.lineMoveChecker.isLinkTransitioned(this.boxLink, this.middleLine, this.childLine.getP1());
        }
    }

    private void positionArc() {
        Line2D.Double reversedMiddleLine = new Line2D.Double(this.middleLine.getP2(), this.middleLine.getP1());
        this.childArc = new LineBasedArcBuilder().getArc(this.childLine, reversedMiddleLine);
        this.parentArc = new LineBasedArcBuilder().getArc(this.parentLine, this.middleLine);
    }

    private void positionJoints() {
        Point2D jointPoint = this.threeLinePositioner.getChildJointEndPoint();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, ((IEdgeTrackable)((Object)this.boxLink)).getChildEdge(), "ChildJoint");
        jointPoint = this.threeLinePositioner.getParentJointEndPoint();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, ((IEdgeTrackable)((Object)this.boxLink)).getParentEdge(), "ParentJoint");
    }
}

