/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.user;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.core.IRawLineSource;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public final class LinkLineExtractor {
    public List<PositionableLine> getPositionableLines(BoxLink boxLink) {
        List<? extends Shape> shapes = boxLink instanceof IRawLineSource ? ((IRawLineSource)((Object)boxLink)).getRawLines() : boxLink.getShapes();
        ArrayList<PositionableLine> positionableLines = new ArrayList<PositionableLine>();
        for (Shape shape : shapes) {
            if (!(shape instanceof PositionableLine)) continue;
            positionableLines.add((PositionableLine)shape);
        }
        return positionableLines;
    }

    public static void extractLines(List<? extends Shape> shapes, List<Line2D> targetList) {
        targetList.clear();
        for (Shape shape : shapes) {
            if (!(shape instanceof Line2D)) continue;
            targetList.add((Line2D)shape);
        }
    }

    public PositionableLine getParentLine(BoxLink link) {
        return this.getLineByRole(link, LineRole.PARENT_LINE);
    }

    public PositionableLine getChildLine(BoxLink link) {
        return this.getLineByRole(link, LineRole.CHILD_LINE);
    }

    private PositionableLine getLineByRole(BoxLink link, LineRole lineRole) {
        for (PositionableLine line : this.getPositionableLines(link)) {
            if (!line.getLineRole().equals((Object)lineRole)) continue;
            return line;
        }
        return null;
    }
}

