/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.common;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.calc.ArcCompensator;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.BoxPointCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public final class TwoLinePositioner {
    private Rectangle2D parentBox;
    private Rectangle2D childBox;
    private final BoxPointCalc boxPointCalc = new BoxPointCalc();
    private final ArcCompensator arcCompensator = new ArcCompensator();
    private Point2D intersect;
    private Point2D childEndPointA;
    private Point2D childEndPointB;
    private Point2D parentEndPointA;
    private Point2D parentEndPointB;
    private PositionableLine parentLine;
    private PositionableLine childLine;
    private Edge parentEdge;
    private Edge childEdge;
    private BoxLink boxLink;
    private LinkRect parentRect;
    private LinkRect childRect;

    public void positionLines(BoxLink boxLink, Point2D intersect) {
        this.intersect = intersect;
        this.boxLink = boxLink;
        this.parentBox = boxLink.getBox(boxLink.getParentBoxName());
        this.parentRect = new LinkRect(this.parentBox, "Parent");
        this.childBox = boxLink.getBox(boxLink.getChildBoxName());
        this.childRect = new LinkRect(this.childBox, "Child");
        this.extractLines();
        this.parentEdge = ((IEdgeTrackable)((Object)boxLink)).getParentEdge();
        this.childEdge = ((IEdgeTrackable)((Object)boxLink)).getChildEdge();
        this.calcEndPoints();
        this.updateLines();
    }

    private void calcEndPoints() {
        this.parentEndPointA = this.getBoxPoint(this.parentBox, this.parentEdge);
        this.parentEndPointB = this.getArcPoint(this.parentEdge);
        this.childEndPointA = this.getBoxPoint(this.childBox, this.childEdge);
        this.childEndPointB = this.getArcPoint(this.childEdge);
    }

    private void updateLines() {
        this.checkCreateLines();
        if (this.boxLink instanceof IEdgeTrackable) {
            IEdgeTrackable edgeTrackable = (IEdgeTrackable)((Object)this.boxLink);
            edgeTrackable.setParentEdge(this.parentEdge);
            edgeTrackable.setChildEdge(this.childEdge);
        }
    }

    private void checkCreateLines() {
        if (this.parentLine == null) {
            this.parentLine = new PositionableLine(this.parentEndPointA, this.parentEndPointB, this.parentRect, LineRole.PARENT_LINE);
        } else {
            this.parentLine.setLine(this.parentEndPointA, this.parentEndPointB);
            this.parentLine.updateAbs(this.boxLink);
        }
        if (this.childLine == null) {
            this.childLine = new PositionableLine(this.childEndPointA, this.childEndPointB, this.childRect, LineRole.CHILD_LINE);
        } else {
            this.childLine.setLine(this.childEndPointA, this.childEndPointB);
        }
    }

    private Point2D getArcPoint(Edge edge) {
        return this.arcCompensator.getArcCompensatedPoint(edge, this.intersect);
    }

    private Point2D getBoxPoint(Rectangle2D box, Edge edge) {
        return this.boxPointCalc.getLineEndPoint(box, edge, this.intersect);
    }

    public PositionableLine getChildLine() {
        return this.childLine;
    }

    public PositionableLine getParentLine() {
        return this.parentLine;
    }

    public Point2D getParentJointEndPoint() {
        return this.boxPointCalc.getJointEndPoint(this.parentBox, this.parentEdge, this.intersect);
    }

    public Point2D getChildJointEndPoint() {
        return this.boxPointCalc.getJointEndPoint(this.childBox, this.childEdge, this.intersect);
    }

    private void extractLines() {
        LinkLineExtractor extractor = new LinkLineExtractor();
        List<PositionableLine> lines = extractor.getPositionableLines(this.boxLink);
        if (lines.size() > 0) {
            this.parentLine = lines.get(0);
        }
        if (lines.size() > 1) {
            this.childLine = lines.get(1);
        }
    }
}

