/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.comparator;

import com.harrand.sketch.core.geometry.ECoordinate;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;

public final class CoordinateDifferenceSocketComparator
implements Comparator<JointSocket> {
    private final Rectangle2D baseRect;
    private ECoordinate coordinate;
    private Double baseValue;
    private Double valueA;
    private Double valueB;
    private JointSocket socketA;
    private JointSocket socketB;

    public CoordinateDifferenceSocketComparator(ECoordinate coordinate, Rectangle2D baseRect) {
        this.coordinate = coordinate;
        this.baseRect = baseRect;
    }

    @Override
    public int compare(JointSocket socketA, JointSocket socketB) {
        this.socketA = socketA;
        this.socketB = socketB;
        this.setValues();
        Double diffA = this.valueA - this.baseValue;
        Double diffB = this.valueB - this.baseValue;
        return diffA.compareTo(diffB);
    }

    private void setValues() {
        if (ECoordinate.X.equals((Object)this.coordinate)) {
            this.valueA = this.socketA.getComplimentaryRect().getCenterX();
            this.valueB = this.socketB.getComplimentaryRect().getCenterX();
            this.baseValue = this.baseRect.getCenterX();
        } else {
            this.valueA = this.socketA.getComplimentaryRect().getCenterY();
            this.valueB = this.socketB.getComplimentaryRect().getCenterY();
            this.baseValue = this.baseRect.getCenterY();
        }
    }
}

