/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket;

import com.harrand.sketch.core.geometry.ECoordinate;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.Bearing;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.edge.CornerBearingEdgeCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.edge.DirectBearingEdgeCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.edge.IBearingEdgeCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import java.util.ArrayList;
import java.util.List;

public final class BearingSockets {
    private Bearing bearing;
    private List<JointSocket> sockets = new ArrayList<JointSocket>();

    public BearingSockets(Bearing bearing) {
        this.bearing = bearing;
    }

    public List<JointSocket> getRankedSockets(LinkedBox linkedBox) {
        IBearingEdgeCalc edgeRankingCalc = this.getEdgeRankingCalc();
        edgeRankingCalc.updateSocketEdges(linkedBox, this);
        return this.getSockets();
    }

    public void addSocket(JointSocket socket) {
        this.sockets.add(socket);
    }

    public List<JointSocket> getSockets() {
        return new ArrayList<JointSocket>(this.sockets);
    }

    public Bearing getBearing() {
        return this.bearing;
    }

    private IBearingEdgeCalc getEdgeRankingCalc() {
        switch (this.bearing) {
            case NORTH: {
                return new DirectBearingEdgeCalc(ECoordinate.X);
            }
            case EAST: {
                return new DirectBearingEdgeCalc(ECoordinate.Y);
            }
            case SOUTH: {
                return new DirectBearingEdgeCalc(ECoordinate.X);
            }
            case WEST: {
                return new DirectBearingEdgeCalc(ECoordinate.Y);
            }
            case NORTH_EAST: {
                return new CornerBearingEdgeCalc();
            }
            case SOUTH_EAST: {
                return new CornerBearingEdgeCalc();
            }
            case SOUTH_WEST: {
                return new CornerBearingEdgeCalc();
            }
            case NORTH_WEST: {
                return new CornerBearingEdgeCalc();
            }
        }
        return null;
    }
}

