/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.arc.LineBasedArcBuilder;
import com.harrand.sketch.linkStrategies.right_angle.calc.JointPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.NamePositionCoordSetter;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.LinkAutoLayoutInfo;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer.ILinkPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.TwoLinePositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.intersect.TwoLineLinkInfoIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineUserLinkPositioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.PositionableLine;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public final class TwoLineLinkPositionInitializer
implements ILinkPositionInitializer {
    private final TwoLineLinkInfoIntersectCalc intersectCalc = new TwoLineLinkInfoIntersectCalc();
    private final TwoLinePositioner linePositioner = new TwoLinePositioner();
    private final JointPositioner jointPositioner = new JointPositioner();
    private BoxLink boxLink;
    private PositionableLine parentLine;
    private PositionableLine childLine;
    private LinkAutoLayoutInfo linkAutoLayoutInfo;
    private final NamePositionCoordSetter namePositionCoordSetter = new NamePositionCoordSetter();
    private Arc2D arc;

    @Override
    public void initializeLinkPosition(LinkAutoLayoutInfo linkAutoLayoutInfo) {
        this.linkAutoLayoutInfo = linkAutoLayoutInfo;
        this.boxLink = linkAutoLayoutInfo.getBoxLink();
        this.setLinkEdges(linkAutoLayoutInfo);
        this.positionLines();
        this.positionArc();
        this.positionJoints();
        this.namePositionCoordSetter.setNmPos(this.boxLink, this.parentLine);
        this.boxLink.setShapes(this.getShapes());
        this.boxLink.setLinkPositioner(new TwoLineUserLinkPositioner());
    }

    private List<Shape> getShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        shapes.add(this.parentLine);
        shapes.add(this.childLine);
        if (this.arc != null) {
            shapes.add(this.arc);
        }
        return shapes;
    }

    private void positionLines() {
        Point2D intersect = this.intersectCalc.calcIntersect(this.linkAutoLayoutInfo);
        this.linePositioner.positionLines(this.boxLink, intersect);
        this.parentLine = this.linePositioner.getParentLine();
        this.childLine = this.linePositioner.getChildLine();
    }

    private void positionArc() {
        this.arc = new LineBasedArcBuilder().getArc(this.childLine, this.parentLine);
    }

    private void positionJoints() {
        Point2D jointPoint = this.linePositioner.getChildJointEndPoint();
        Edge childEdge = this.linkAutoLayoutInfo.getChildJointSocket().getEdge();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, childEdge, "ChildJoint");
        jointPoint = this.linePositioner.getParentJointEndPoint();
        Edge parentEdge = this.linkAutoLayoutInfo.getParentJointSocket().getEdge();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, parentEdge, "ParentJoint");
    }

    private void setLinkEdges(LinkAutoLayoutInfo linkAutoLayoutInfo) {
        IEdgeTrackable edgeTrackable = (IEdgeTrackable)((Object)this.boxLink);
        edgeTrackable.setParentEdge(linkAutoLayoutInfo.getParentJointSocket().getEdge());
        edgeTrackable.setChildEdge(linkAutoLayoutInfo.getChildJointSocket().getEdge());
    }
}

