/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.arc.LineBasedArcBuilder;
import com.harrand.sketch.linkStrategies.right_angle.calc.JointPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.NamePositionCoordSetter;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.LinkAutoLayoutInfo;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer.ILinkPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.ThreeLinePositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.intersect.ThreeLineLinkInfoIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.ThreeLineUserLinkPositioner;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.PositionableLine;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public final class ThreeLineLinkPositionInitializer
implements ILinkPositionInitializer {
    private final ThreeLineLinkInfoIntersectCalc intersectCalc = new ThreeLineLinkInfoIntersectCalc();
    private final ThreeLinePositioner linePositioner = new ThreeLinePositioner();
    private final JointPositioner jointPositioner = new JointPositioner();
    private BoxLink boxLink;
    private final NamePositionCoordSetter namePositionCoordSetter = new NamePositionCoordSetter();
    private PositionableLine childLine;
    private PositionableLine middleLine;
    private PositionableLine parentLine;
    private Arc2D childArc;
    private Arc2D parentArc;
    private LinkAutoLayoutInfo linkAutoLayoutInfo;

    @Override
    public void initializeLinkPosition(LinkAutoLayoutInfo linkAutoLayoutInfo) {
        this.linkAutoLayoutInfo = linkAutoLayoutInfo;
        this.boxLink = linkAutoLayoutInfo.getBoxLink();
        this.positionLines();
        this.positionArc();
        this.positionJoints();
        this.updateShapes();
        this.boxLink.setLinkPositioner(new ThreeLineUserLinkPositioner());
    }

    private void updateShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        shapes.add(this.parentLine);
        shapes.add(this.childLine);
        shapes.add(this.middleLine);
        if (this.parentArc != null) {
            shapes.add(this.parentArc);
        }
        if (this.childArc != null) {
            shapes.add(this.childArc);
        }
        this.boxLink.setShapes(shapes);
        this.namePositionCoordSetter.setNmPos(this.boxLink, this.middleLine);
    }

    private void positionLines() {
        Point2D[] parentAndChildIntersects = this.intersectCalc.calcParentAndChildIntersects(this.linkAutoLayoutInfo);
        this.linePositioner.positionLines(this.boxLink, parentAndChildIntersects);
        this.parentLine = this.linePositioner.getParentLine();
        this.childLine = this.linePositioner.getChildLine();
        this.middleLine = this.linePositioner.getMiddleLine();
    }

    private void positionArc() {
        Line2D.Double reversedMiddleLine = new Line2D.Double(this.middleLine.getP2(), this.middleLine.getP1());
        this.childArc = new LineBasedArcBuilder().getArc(this.childLine, reversedMiddleLine);
        this.parentArc = new LineBasedArcBuilder().getArc(this.parentLine, this.middleLine);
    }

    private void positionJoints() {
        Point2D jointPoint = this.linePositioner.getChildJointEndPoint();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, ((IEdgeTrackable)((Object)this.boxLink)).getChildEdge(), "ChildJoint");
        jointPoint = this.linePositioner.getParentJointEndPoint();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, ((IEdgeTrackable)((Object)this.boxLink)).getParentEdge(), "ParentJoint");
    }
}

