/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer;

import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.LinkAutoPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import java.util.ArrayList;

public final class SingleLinkPositionInitializer {
    public void initializeLinkPosition(Database db, Table parentTable, Table childTable) {
        LinkAutoPositionInitializer linkAutoPositionInitializer = new LinkAutoPositionInitializer();
        for (Diagram diagram : db.getDiagramsGen()) {
            if (!diagram.getRenderConfig().isRightAngleLinkStrategy()) continue;
            DbTableGlyph parentGlyph = (DbTableGlyph)diagram.getGlyph(parentTable.getDotNote());
            DbTableGlyph childGlyph = (DbTableGlyph)diagram.getGlyph(childTable.getDotNote());
            if (parentGlyph == null || childGlyph == null) continue;
            ForeignKey fk = childTable.getForeignKeyByParentTable(parentTable.getDotNote());
            Link link = diagram.getLink(fk.getDotNote());
            LinkBoxPair linkBoxPair = new LinkBoxPair(link);
            linkBoxPair.setChildBox(childGlyph.getDiagramBox());
            linkBoxPair.setParentBox(parentGlyph.getDiagramBox());
            ArrayList<LinkBoxPair> linkBoxPairs = new ArrayList<LinkBoxPair>();
            linkBoxPairs.add(linkBoxPair);
            linkAutoPositionInitializer.initializeLinkPositions(linkBoxPairs);
        }
    }
}

