/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.core.box.DiagramBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBox;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LinkedBoxFactory {
    private Set<LinkedBox> linkedBoxSet;

    public List<LinkedBox> createLinkedBoxes(List<LinkBoxPair> linkBoxPairs) {
        this.linkedBoxSet = new HashSet<LinkedBox>();
        for (LinkBoxPair linkBoxPair : linkBoxPairs) {
            BoxLink boxLink = linkBoxPair.getBoxLink();
            this.addLink(linkBoxPair.getParentBox(), boxLink);
            this.addLink(linkBoxPair.getChildBox(), boxLink);
        }
        return new ArrayList<LinkedBox>(this.linkedBoxSet);
    }

    private void addLink(DiagramBox diagramBox, BoxLink boxLink) {
        LinkedBox linkedBox = this.findOrCreateLinkedBox(diagramBox);
        linkedBox.addBoxLink(boxLink);
    }

    private LinkedBox findOrCreateLinkedBox(DiagramBox diagramBox) {
        String boxDotNote = diagramBox.getDotNote();
        for (LinkedBox linkedBox : this.linkedBoxSet) {
            if (!linkedBox.getDotNote().equals(boxDotNote)) continue;
            return linkedBox;
        }
        LinkedBox linkedBox = new LinkedBox(diagramBox);
        this.linkedBoxSet.add(linkedBox);
        return linkedBox;
    }
}

