/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.edge;

import com.harrand.sketch.core.geometry.ECoordinate;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.Bearing;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.edge.IBearingEdgeCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.BearingSockets;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeRanking;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.comparator.CoordinateDifferenceSocketComparator;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.util.LogUtil;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;

public final class DirectBearingEdgeCalc
implements IBearingEdgeCalc {
    public static final int MIDDLE_BEARING_RANK = 1;
    private ECoordinate coordinate;
    private Bearing bearing;

    public DirectBearingEdgeCalc(ECoordinate coordinate) {
        this.coordinate = coordinate;
    }

    @Override
    public void updateSocketEdges(LinkedBox linkedBox, BearingSockets bearingSockets) {
        this.bearing = bearingSockets.getBearing();
        ArrayList<JointSocket> sockets = new ArrayList<JointSocket>(bearingSockets.getSockets());
        Rectangle2D baseRect = linkedBox.getDiagramBox().getRect();
        CoordinateDifferenceSocketComparator socketComparator = new CoordinateDifferenceSocketComparator(this.coordinate, baseRect);
        Collections.sort(sockets, socketComparator);
        int i = 0;
        for (JointSocket socket : sockets) {
            Edge edge = this.getEdge();
            socket.setEdge(edge);
            socket.setEdgeRank(new EdgeRanking(edge, 1, i++));
            socket.getLinkBoxPair().setLinkLineCount(1);
        }
    }

    private Edge getEdge() {
        switch (this.bearing) {
            case NORTH: {
                return Edge.NORTH;
            }
            case WEST: {
                return Edge.WEST;
            }
            case SOUTH: {
                return Edge.SOUTH;
            }
            case EAST: {
                return Edge.EAST;
            }
        }
        LogUtil.logErr(this.getClass().getName() + ": Could not determinE Edge for bearing: " + (Object)((Object)this.bearing));
        return null;
    }
}

