/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.LinkAutoLayoutInfo;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.LinkBearingCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBoxFactory;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBoxLinkCountComparator;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeSocketCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeSocketPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeSockets;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import com.harrand.sketch.relation.edge.Edge;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LinkAutoLayoutInfoCalc {
    private Map<BoxLink, LinkAutoLayoutInfo> linkInfosMap;

    public Map<BoxLink, LinkAutoLayoutInfo> getLinkAutoLayoutInfos(List<LinkBoxPair> linkBoxPairs) {
        this.linkInfosMap = new HashMap<BoxLink, LinkAutoLayoutInfo>();
        this.calcBearings(linkBoxPairs);
        this.positionSockets(linkBoxPairs);
        return this.linkInfosMap;
    }

    private void calcBearings(List<LinkBoxPair> linkBoxPairs) {
        LinkBearingCalc linkBearingCalc = new LinkBearingCalc();
        for (LinkBoxPair linkBoxPair : linkBoxPairs) {
            Rectangle2D parentRect = linkBoxPair.getParentBox().getRect();
            Rectangle2D childRect = linkBoxPair.getChildBox().getRect();
            linkBoxPair.setParentBearing(linkBearingCalc.getRectABearing(parentRect, childRect));
            linkBoxPair.setChildBearing(linkBearingCalc.getRectABearing(childRect, parentRect));
        }
    }

    private void positionSockets(List<LinkBoxPair> linkBoxPairs) {
        EdgeSocketCalc edgeSocketcalc = new EdgeSocketCalc();
        EdgeSocketPositioner edgeSocketPositioner = new EdgeSocketPositioner();
        List<LinkedBox> linkCountSortedLinkedBoxes = this.getLinkCountSortedLinkedBoxes(linkBoxPairs);
        for (LinkedBox linkedBox : linkCountSortedLinkedBoxes) {
            Map<Edge, EdgeSockets> edgeSocketsMap = edgeSocketcalc.getEdgeSockets(linkedBox, linkBoxPairs);
            edgeSocketPositioner.setOffsets(linkedBox, edgeSocketsMap);
            this.addToLinkInfos(edgeSocketsMap);
        }
    }

    private List<LinkedBox> getLinkCountSortedLinkedBoxes(List<LinkBoxPair> linkBoxPairs) {
        List<LinkedBox> linkedBoxes = new LinkedBoxFactory().createLinkedBoxes(linkBoxPairs);
        Collections.sort(linkedBoxes, new LinkedBoxLinkCountComparator());
        Collections.reverse(linkedBoxes);
        return linkedBoxes;
    }

    private void addToLinkInfos(Map<Edge, EdgeSockets> edgeSocketsMap) {
        for (JointSocket socket : this.getBoxSockets(edgeSocketsMap)) {
            LinkBoxPair linkBoxPair = socket.getLinkBoxPair();
            BoxLink boxLink = linkBoxPair.getBoxLink();
            if (this.linkInfosMap.containsKey(boxLink)) continue;
            LinkAutoLayoutInfo linkInfo = new LinkAutoLayoutInfo();
            linkInfo.setBoxLink(boxLink);
            linkInfo.setLinkBoxPair(linkBoxPair);
            this.linkInfosMap.put(boxLink, linkInfo);
        }
    }

    private List<JointSocket> getBoxSockets(Map<Edge, EdgeSockets> edgeSocketsMap) {
        ArrayList<JointSocket> boxSockets = new ArrayList<JointSocket>();
        for (EdgeSockets edgeSockets : edgeSocketsMap.values()) {
            boxSockets.addAll(new ArrayList<JointSocket>(edgeSockets.getOrderedSockets()));
        }
        return boxSockets;
    }
}

