/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.offset;

import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.IJoint;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.linkStrategies.RectOverlapCalc;
import com.harrand.sketch.linkStrategies.SelfJoinCalc;
import com.harrand.sketch.linkStrategies.calc.CentroidAngleCalc;
import com.harrand.sketch.linkStrategies.calc.EdgeCalc;
import com.harrand.sketch.linkStrategies.linkNm.OffsetDirectNmPositionCalc;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class OffsetCalc {
    private Link link_;
    private SelfJoinCalc selfJoinCalc_ = new SelfJoinCalc();
    private RectOverlapCalc overlapCalc_ = new RectOverlapCalc();
    private double centroidAngleA_;
    private double centroidAngleB_;
    private Rectangle2D boxA_;
    private Rectangle2D boxB_;
    private int edgeA_;
    private int edgeB_;
    private double angleA_;
    private double angleB_;
    private boolean useFollowerPos_;
    public static final int CLOSE_ANGLE = 45;
    public final int NORTH_EDGE = 0;
    public final int EAST_EDGE = 1;
    public final int SOUTH_EDGE = 2;
    public final int WEST_EDGE = 3;

    public void updateLink(Link link) {
        this.link_ = link;
        if (this.link_.getIsSelfJoin()) {
            this.selfJoinCalc_.updateLink(link);
        } else {
            this.refresh();
        }
    }

    public Link getLink() {
        return this.link_;
    }

    public int getEdgeA() {
        return this.edgeA_;
    }

    public int getEdgeB() {
        return this.edgeB_;
    }

    public boolean getUseFollowerPos() {
        return this.useFollowerPos_;
    }

    public double getAngleA() {
        return this.angleA_;
    }

    public double getAngleB() {
        return this.angleB_;
    }

    private void refresh() {
        this.boxA_ = this.link_.getBox("Parent");
        this.boxB_ = this.link_.getBox("Child");
        this.overlapCalc_.doCalcs(this.boxA_, this.boxB_, 8);
        if (this.overlapCalc_.getHasOverlap()) {
            this.useStraightLine();
        } else {
            this.useDiagonalLine();
        }
        ArrayList<Line2D> lines = new ArrayList<Line2D>();
        Line2D connectingLine = this.getConnectionLine();
        lines.add(connectingLine);
        this.setNmPos(connectingLine);
        this.link_.setShapes(lines);
    }

    private void useStraightLine() {
        this.updateJointsStraight();
    }

    private void useDiagonalLine() {
        this.calcCentroidAngles();
        this.calcEdgesToUse();
        this.updateJointsDiagonal();
    }

    private void calcCentroidAngles() {
        double[] angles = CentroidAngleCalc.calcCentroidAngles(this.boxA_, this.boxB_);
        this.centroidAngleA_ = angles[0];
        this.centroidAngleB_ = angles[1];
    }

    private void calcEdgesToUse() {
        this.angleA_ = this.normalizeAngle(this.centroidAngleA_);
        this.angleB_ = this.normalizeAngle(this.centroidAngleB_);
        this.edgeA_ = EdgeCalc.getAngleEdge(this.angleA_, this.boxA_);
        this.edgeB_ = EdgeCalc.getAngleEdge(this.angleB_, this.boxB_);
    }

    private double normalizeAngle(double centroidAngle) {
        double angle = GeometryHelper.normalizeAngle(GeometryHelper.reduceAngle(centroidAngle));
        return angle;
    }

    private void updateJointsStraight() {
        this.link_.moveJoint(this.link_.getParentJointName(), this.overlapCalc_.getJointPtA());
        this.link_.rotateJoint(this.link_.getParentJointName(), this.overlapCalc_.getJointAngleA());
        this.link_.moveJoint(this.link_.getChildJointName(), this.overlapCalc_.getJointPtB());
        this.link_.rotateJoint(this.link_.getChildJointName(), this.overlapCalc_.getJointAngleB());
    }

    private void updateJointsDiagonal() {
        Point2D jointStartB = this.getJointLocation(this.boxB_, this.edgeB_, this.centroidAngleB_);
        this.link_.moveJoint(this.link_.getChildJointName(), jointStartB);
        double jointAngle = this.getJointAngle(this.edgeB_);
        this.link_.rotateJoint(this.link_.getChildJointName(), jointAngle);
        this.useFollowerPos_ = this.useFollowerPosition(this.centroidAngleA_, jointStartB);
        Point2D jointStartA = this.useFollowerPos_ ? this.getFollowerJointLocation(this.boxA_, this.edgeA_, jointStartB) : this.getJointLocation(this.boxA_, this.edgeA_, this.centroidAngleA_);
        this.link_.moveJoint(this.link_.getParentJointName(), jointStartA);
        jointAngle = this.getJointAngle(this.edgeA_);
        this.link_.rotateJoint(this.link_.getParentJointName(), jointAngle);
    }

    private Point2D getJointLocation(Rectangle2D rect, int edge, double angle) {
        double x = rect.getCenterX();
        double y = rect.getCenterY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        double radians = Math.toRadians(angle);
        double tanFactor = Math.tan(radians);
        switch (edge) {
            case 1: {
                x += 0.5 * w;
                y -= 0.5 * w * tanFactor;
                break;
            }
            case 0: {
                x += 0.5 * h / tanFactor;
                y -= 0.5 * h;
                break;
            }
            case 3: {
                x += 0.5 * -w;
                y -= 0.5 * -w * tanFactor;
                break;
            }
            case 2: {
                x += 0.5 * -h / tanFactor;
                y -= 0.5 * -h;
            }
        }
        return new Point2D.Double(x, y);
    }

    private Point2D getFollowerJointLocation(Rectangle2D rect, int edge, Point2D leadJointStart) {
        double x = rect.getCenterX();
        double y = rect.getCenterY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        switch (edge) {
            case 1: {
                x += 0.5 * w;
                y = leadJointStart.getY();
                break;
            }
            case 0: {
                x = leadJointStart.getX();
                y -= 0.5 * h;
                break;
            }
            case 3: {
                x += 0.5 * -w;
                y = leadJointStart.getY();
                break;
            }
            case 2: {
                x = leadJointStart.getX();
                y -= 0.5 * -h;
            }
        }
        return new Point2D.Double(x, y);
    }

    private double getJointAngle(int edge) {
        double angle = 0.0;
        switch (edge) {
            case 1: {
                angle = 0.0;
                break;
            }
            case 0: {
                angle = 90.0;
                break;
            }
            case 3: {
                angle = 180.0;
                break;
            }
            case 2: {
                angle = 270.0;
            }
        }
        return angle;
    }

    private boolean useFollowerPosition(double degrees, Point2D jointStartB) {
        boolean inBounds = true;
        boolean angleOk = this.getFollowerAngleOk(degrees);
        if (angleOk) {
            inBounds = this.getFollowerInBounds(jointStartB);
        }
        boolean followerOk = angleOk && inBounds;
        return followerOk;
    }

    private boolean getFollowerAngleOk(double degrees) {
        double radians = Math.toRadians(degrees);
        double sinMax = Math.abs(Math.sin(Math.toRadians(45.0)));
        double sinValue = Math.abs(Math.sin(radians));
        double cosValue = Math.abs(Math.cos(radians));
        boolean angleOk = sinValue <= sinMax || cosValue <= sinMax;
        return angleOk;
    }

    private boolean getFollowerInBounds(Point2D jointStartB) {
        double jointX;
        double jointY;
        boolean isHorz;
        boolean bl = isHorz = this.edgeA_ == 3 || this.edgeA_ == 1;
        boolean inBounds = isHorz ? (jointY = jointStartB.getY()) >= this.boxA_.getMinY() && jointY <= this.boxA_.getMaxY() : (jointX = jointStartB.getX()) >= this.boxA_.getMinX() && jointX <= this.boxA_.getMaxX();
        return inBounds;
    }

    private Line2D getConnectionLine() {
        IJoint jointA = this.link_.getJoint(this.link_.getParentJointName());
        IJoint jointB = this.link_.getJoint(this.link_.getChildJointName());
        Line2D.Double line = new Line2D.Double(jointA.getEndPoint(), jointB.getEndPoint());
        return line;
    }

    private void setNmPos(Line2D connectingLine) {
        OffsetDirectNmPositionCalc nmPosCalc = new OffsetDirectNmPositionCalc();
        IPositioningCoord nmPosCoord = nmPosCalc.getNmCoord(connectingLine, "NoFlag", false);
        this.link_.setNmPosCoord(nmPosCoord);
    }
}

