/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.linkNm;

import com.harrand.coreclasses.geometry.positioningCoord.BottomCenterCoord;
import com.harrand.coreclasses.geometry.positioningCoord.CenterCoord;
import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.coreclasses.geometry.positioningCoord.RightCenterCoord;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.linkStrategies.linkNm.ILinkNmPositionCalc;
import java.awt.Point;
import java.awt.geom.Line2D;

public class OffsetDirectNmPositionCalc
implements ILinkNmPositionCalc {
    private Line2D namedLine;
    public static final int ABOVE_LINE_SPACE = 6;

    @Override
    public IPositioningCoord getNmCoord(Line2D namedLine, String shiftFlag, boolean isSelfJoin) {
        this.namedLine = namedLine;
        if (isSelfJoin) {
            return this.getSelfJoinCoord();
        }
        return this.getRegularCoord();
    }

    private IPositioningCoord getSelfJoinCoord() {
        int x = (int)(this.namedLine.getX1() + 6.0);
        int y = (int)this.namedLine.getBounds().getCenterY();
        return new RightCenterCoord(new Point(x, y));
    }

    private IPositioningCoord getRegularCoord() {
        if (GeometryHelper.isLineHorizontal(this.namedLine)) {
            return this.getAboveLineCoord();
        }
        return this.getLineCenterCoord();
    }

    private IPositioningCoord getAboveLineCoord() {
        double lineY = this.namedLine.getY1() - 6.0;
        double centerX = this.namedLine.getBounds().getCenterX();
        return new BottomCenterCoord(this.buildPoint(centerX, lineY));
    }

    private Point buildPoint(double centerX, double lineY) {
        return new Point((int)centerX, (int)lineY);
    }

    private IPositioningCoord getLineCenterCoord() {
        double centerX = this.namedLine.getBounds().getCenterX();
        double centerY = this.namedLine.getBounds().getCenterY();
        return new CenterCoord(this.buildPoint(centerX, centerY));
    }
}

