/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.linkNm;

import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.coreclasses.geometry.positioningCoord.LeftCenterCoord;
import com.harrand.coreclasses.geometry.positioningCoord.RightCenterCoord;
import com.harrand.sketch.linkStrategies.linkNm.DynamicHorzOffsetCalc;
import com.harrand.sketch.linkStrategies.linkNm.ILinkNmPositionCalc;
import java.awt.Point;
import java.awt.geom.Line2D;

public class KeyToKeyNmPositionCalc
implements ILinkNmPositionCalc {
    private Line2D namedLine;
    private DynamicHorzOffsetCalc horzOffsetCalc = new DynamicHorzOffsetCalc();
    public static final String DIR_DOWN = "down";
    public static final String DIR_UP = "up";

    @Override
    public IPositioningCoord getNmCoord(Line2D namedLine, String shiftFlag, boolean isSelfJoin) {
        this.namedLine = namedLine;
        int lineX = (int)namedLine.getX1();
        int vertOffset = this.getVertOffset();
        int y = this.getY_Value(isSelfJoin, vertOffset);
        int x = this.getX_Value(lineX, shiftFlag, isSelfJoin, vertOffset);
        if (this.isLeftShift(shiftFlag)) {
            return new RightCenterCoord(new Point(x, y));
        }
        return new LeftCenterCoord(new Point(x, y));
    }

    private int getVertOffset() {
        int lineLength = (int)this.namedLine.getBounds().getHeight();
        int vertOffset = (int)(0.3 * (double)lineLength);
        return vertOffset;
    }

    private boolean isLeftShift(String shiftFlag) {
        return shiftFlag.equalsIgnoreCase("ShiftLeft");
    }

    private int getX_Value(int lineX, String shiftFlag, boolean isSelfJoin, int centerY) {
        if (isSelfJoin) {
            return lineX - 6;
        }
        if (this.isLeftShift(shiftFlag)) {
            return lineX + this.getHorzOffsetDynamic(centerY);
        }
        return lineX - this.getHorzOffsetDynamic(centerY);
    }

    private int getY_Value(boolean isSelfJoin, int vertOffset) {
        if (isSelfJoin) {
            return this.getY_ValueSelfJoin();
        }
        return this.getY_ValueRegular(vertOffset);
    }

    private int getY_ValueRegular(int vertOffset) {
        String dirStr = this.getLineDirection();
        int pos = dirStr.equalsIgnoreCase(DIR_DOWN) ? (int)this.namedLine.getY1() - vertOffset : (int)this.namedLine.getY1() + vertOffset;
        return pos;
    }

    private int getY_ValueSelfJoin() {
        return (int)this.namedLine.getBounds().getCenterY();
    }

    private String getLineDirection() {
        if (this.namedLine.getY2() > this.namedLine.getY1()) {
            return DIR_UP;
        }
        return DIR_DOWN;
    }

    private int getHorzOffsetDynamic(int verticalOffset) {
        int dynamicHorzOffset = this.horzOffsetCalc.getDynamicHorzOffset(verticalOffset);
        return dynamicHorzOffset;
    }
}

