/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.calc;

import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.util.LogUtil;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class EdgeCalc {
    public static Edge getEdgeFromLineDirection(Line2D line) {
        Point2D p1 = line.getP1();
        Point2D p2 = line.getP2();
        boolean isHorizontal = GeometryHelper.isLineHorizontal(line);
        if (isHorizontal) {
            if (p1.getX() <= p2.getX()) {
                return Edge.EAST;
            }
            return Edge.WEST;
        }
        boolean isVertical = GeometryHelper.isLineVertical(line);
        if (isVertical) {
            if (p1.getY() <= p2.getY()) {
                return Edge.SOUTH;
            }
            return Edge.NORTH;
        }
        LogUtil.logErr("EdgeCalc.could not get edge from line direction. Line was probably not vertical or horizontal.");
        return null;
    }

    public static Edge getOppositeEdge(Edge edge) {
        switch (edge) {
            case NORTH: {
                return Edge.SOUTH;
            }
            case SOUTH: {
                return Edge.NORTH;
            }
            case WEST: {
                return Edge.EAST;
            }
            case EAST: {
                return Edge.WEST;
            }
        }
        return null;
    }

    public static int getAngleEdge(double angle, Rectangle2D box) {
        double boundary = Math.toDegrees(Math.atan2(0.5 * box.getHeight(), 0.5 * box.getWidth()));
        if (angle <= boundary || angle >= 360.0 - boundary) {
            return 1;
        }
        if (angle > boundary && angle < 180.0 - boundary) {
            return 0;
        }
        if (angle >= 180.0 - boundary && angle <= 180.0 + boundary) {
            return 3;
        }
        if (angle > 180.0 + boundary && angle <= 360.0 - boundary) {
            return 2;
        }
        return 0;
    }
}

