/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.arc;

import com.harrand.sketch.linkStrategies.arc.ArcQuadrant;
import com.harrand.sketch.linkStrategies.arc.ArcQuadrantCalc;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public final class ArcBldr {
    public static final int ARC_RADIUS = 3;
    public static final int ARC_SPACE = 4;
    public static final double DIAMETER = 6.0;
    public static final int DIAMETER_INT = 6;
    public static final int ANGLE_EXTENT = 90;

    public Arc2D getArc(Point2D ptA, Point2D ptB) {
        ArcQuadrant quad = ArcQuadrantCalc.getArcQuadrant(ptA, ptB);
        int startAngle = quad.getStartAngle();
        Point2D arcOrigin = quad.getOriginPt(ptA, 3.0);
        double x = arcOrigin.getX();
        double y = arcOrigin.getY();
        Arc2D.Double arc = new Arc2D.Double(x, y, 6.0, 6.0, startAngle, 90.0, 0);
        return arc;
    }

    public Arc2D getArc(Line2D horzLine, Line2D vertLine, boolean isHorzLineLead) {
        ArcQuadrant quad = ArcQuadrantCalc.getArcQuadrant(horzLine, vertLine, isHorzLineLead);
        int startAngle = quad.getStartAngle();
        Point2D arcBackCorner = isHorzLineLead ? horzLine.getP2() : horzLine.getP1();
        Arc2D arc = this.buildDisp(quad, arcBackCorner, startAngle);
        return arc;
    }

    private Arc2D buildDisp(ArcQuadrant quad, Point2D arcBackCorner, int startAngle) {
        double yMove;
        double xMove;
        if (quad.equals((Object)ArcQuadrant.QUAD_1)) {
            xMove = -6.0;
            yMove = 0.0;
        } else if (quad.equals((Object)ArcQuadrant.QUAD_2)) {
            xMove = 0.0;
            yMove = 0.0;
        } else if (quad.equals((Object)ArcQuadrant.QUAD_3)) {
            xMove = 0.0;
            yMove = -6.0;
        } else {
            xMove = -6.0;
            yMove = -6.0;
        }
        double x = arcBackCorner.getX() + xMove;
        double y = arcBackCorner.getY() + yMove;
        Arc2D.Double arc = new Arc2D.Double(x, y, 6.0, 6.0, startAngle, 90.0, 0);
        return arc;
    }
}

