/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.shadow;

import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.shadow.RoundRectSpotShadow;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class RoundRectSpotShadowFactory {
    public List<IDrawable> getShadows(List<? extends Glyph> glyphs, double radius) {
        ArrayList<IDrawable> shadows = new ArrayList<IDrawable>();
        for (Glyph glyph : glyphs) {
            shadows.add(this.getShadow(glyph, radius));
        }
        return shadows;
    }

    public RoundRectSpotShadow getShadow(Glyph glyph, double radius) {
        Rectangle2D rect = glyph.getBounds2D();
        String nm = glyph.getName();
        RoundRectangle2D roundRect = GeometryHelper.getRoundRect(rect, radius);
        RoundRectSpotShadow shadow = new RoundRectSpotShadow(roundRect, nm);
        return shadow;
    }
}

