/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.shadow;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.draw.shape.helper.FillRectHelper;
import com.harrand.sketch.xml.svg.bldr.glyph.SvgRoundRectSpotShadowBldr;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RoundRectSpotShadow
implements IDrawable,
ISvgShape {
    private String name;
    private RoundRectangle2D rect;
    private RoundRectangle2D lastRect;
    private Zoom lastZoom;
    private List<EnhancedShape> shadingRects = new ArrayList<EnhancedShape>();

    public RoundRectSpotShadow(RoundRectangle2D rect, String name) {
        this.name = name;
        this.setRect(rect);
        this.refreshShapes(new Zoom(1.0));
    }

    public final void setRect(RoundRectangle2D rect) {
        this.rect = new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth() + 1.0, rect.getHeight() + 1.0, rect.getArcWidth(), rect.getArcHeight());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        boolean zoomChanged;
        boolean bl = zoomChanged = !this.lastZoom.equals(zoom);
        if (zoomChanged || !this.canReuseShapes()) {
            this.refreshShapes(zoom);
        }
        Paint oldPaint = g2.getPaint();
        for (IDrawable iDrawable : this.shadingRects) {
            iDrawable.draw(g2, zoom);
        }
        g2.setPaint(oldPaint);
    }

    public List<EnhancedShape> getShapes() {
        return this.shadingRects;
    }

    private void refreshShapes(Zoom zoom) {
        int count = 2;
        int i = 0;
        this.updateShadingRect(i++, count, Colors.getGrayVeryLight());
        this.updateShadingRect(i++, count, Colors.getGrayVeryLight());
        this.lastZoom = new Zoom(zoom.getLevel());
        this.lastRect = this.rect;
    }

    private EnhancedShape updateShadingRect(int i, int count, Color color) {
        EnhancedShape eShape = null;
        int offset = count - i;
        if (i < this.shadingRects.size()) {
            EnhancedShape currentE_Shape = this.shadingRects.get(i);
            FillRectHelper.updateFillRectShape(currentE_Shape, this.rect, offset, color);
            eShape = currentE_Shape;
        } else {
            eShape = FillRectHelper.createFillRectShape(this.rect, offset, color);
            this.shadingRects.add(0, eShape);
        }
        return eShape;
    }

    private boolean canReuseShapes() {
        if (this.shadingRects.isEmpty()) {
            return false;
        }
        boolean isSameRect = this.isRectSame();
        return isSameRect;
    }

    private boolean isRectSame() {
        if (this.lastRect == null || this.rect == null) {
            return false;
        }
        return GeometryHelper.isRectSame(this.lastRect, this.rect);
    }

    private Color getTransparentColor(Color colorIn, int alpha) {
        return Colors.getTransparentColor(colorIn, alpha);
    }

    @Override
    public Element getSvgElm(Document doc) {
        SvgRoundRectSpotShadowBldr svgBldr = new SvgRoundRectSpotShadowBldr(this.shadingRects);
        return svgBldr.getSvgElm(doc);
    }
}

